/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.input;

import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmlunit.input.CommentLessSource;
import org.xmlunit.util.Convert;

public class CommentLessSourceTest {
    @Test
    public void stripCommentsAtDifferentLevels() {
        StreamSource s = new StreamSource(new StringReader("<?xml version='1.0'?><!-- comment 1 --><foo><!-- comment 2 --></foo>"));
        CommentLessSource cls = new CommentLessSource((Source)s);
        Document d = Convert.toDocument((Source)cls);
        Assert.assertEquals((long)1L, (long)d.getChildNodes().getLength());
        Assert.assertTrue((boolean)(d.getChildNodes().item(0) instanceof Element));
        Assert.assertEquals((long)0L, (long)d.getChildNodes().item(0).getChildNodes().getLength());
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantWrapNullSource() {
        new CommentLessSource(null);
    }
}

