/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.input;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.input.NormalizedSource;

public class NormalizedSourceTest {
    private Document doc;

    @Before
    public void createDoc() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    @Test
    public void canWrapNullNode() {
        new NormalizedSource((Node)null);
    }

    @Test
    public void canWrapNullDocument() {
        new NormalizedSource((Document)null);
    }

    @Test
    public void canWrapNullSource() {
        new NormalizedSource((Source)null);
    }

    @Test
    public void normalizesNode() {
        Element control = this.doc.createElement("e");
        control.appendChild(this.doc.createTextNode("a"));
        control.appendChild(this.doc.createTextNode(""));
        control.appendChild(this.doc.createTextNode("b"));
        NormalizedSource s = new NormalizedSource((Node)control);
        Assert.assertEquals((long)1L, (long)s.getNode().getChildNodes().getLength());
        Assert.assertEquals((Object)"ab", (Object)s.getNode().getFirstChild().getNodeValue());
    }

    @Test
    public void normalizesNodeAfterSetNode() {
        Element control = this.doc.createElement("e");
        control.appendChild(this.doc.createTextNode("a"));
        control.appendChild(this.doc.createTextNode(""));
        control.appendChild(this.doc.createTextNode("b"));
        NormalizedSource s = new NormalizedSource();
        s.setNode((Node)control);
        Assert.assertEquals((long)1L, (long)s.getNode().getChildNodes().getLength());
        Assert.assertEquals((Object)"ab", (Object)s.getNode().getFirstChild().getNodeValue());
    }

    @Test
    public void normalizesDocument() {
        Element control = this.doc.createElement("e");
        this.doc.appendChild(control);
        control.appendChild(this.doc.createTextNode("a"));
        control.appendChild(this.doc.createTextNode(""));
        control.appendChild(this.doc.createTextNode("b"));
        NormalizedSource s = new NormalizedSource(this.doc);
        Assert.assertEquals((long)1L, (long)s.getNode().getChildNodes().getLength());
        Assert.assertEquals((long)1L, (long)s.getNode().getFirstChild().getChildNodes().getLength());
        Assert.assertEquals((Object)"ab", (Object)s.getNode().getFirstChild().getFirstChild().getNodeValue());
    }

    @Test
    public void normalizesDOMSource() {
        Element control = this.doc.createElement("e");
        this.doc.appendChild(control);
        control.appendChild(this.doc.createTextNode("a"));
        control.appendChild(this.doc.createTextNode(""));
        control.appendChild(this.doc.createTextNode("b"));
        NormalizedSource s = new NormalizedSource((Source)new DOMSource(this.doc));
        Assert.assertEquals((long)1L, (long)s.getNode().getChildNodes().getLength());
        Assert.assertEquals((long)1L, (long)s.getNode().getFirstChild().getChildNodes().getLength());
        Assert.assertEquals((Object)"ab", (Object)s.getNode().getFirstChild().getFirstChild().getNodeValue());
    }

    @Test
    public void keepsSystemId() {
        NormalizedSource s = new NormalizedSource((Source)new DOMSource(this.doc, "foo"));
        Assert.assertEquals((Object)"foo", (Object)s.getSystemId());
    }
}

