/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.transform;

import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.w3c.dom.Document;
import org.xmlunit.ConfigurationException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.Input;
import org.xmlunit.transform.Transformation;

public class TransformationTest {
    private Transformation t;
    @Mock
    private TransformerFactory fac;
    @Mock
    private Transformer transformer;

    @Before
    public void setupMocks() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.fac.newTransformer((Source)Mockito.any(Source.class))).thenReturn((Object)this.transformer);
        Mockito.when((Object)this.fac.newTransformer()).thenReturn((Object)this.transformer);
    }

    @Before
    public void createTransformation() {
        this.t = new Transformation(Input.fromFile((String)"../test-resources/testAnimal.xml").build());
        this.t.setStylesheet(Input.fromFile((String)"../test-resources/animal.xsl").build());
    }

    @Test
    public void transformAnimalToString() {
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><dog/>", (Object)this.t.transformToString());
    }

    @Test
    public void transformAnimalToDocument() {
        Document doc = this.t.transformToDocument();
        Assert.assertEquals((Object)"dog", (Object)doc.getDocumentElement().getTagName());
    }

    @Test
    public void transformAnimalToHtml() {
        this.t.addOutputProperty("method", "html");
        Assert.assertThat((Object)this.t.transformToString(), (Matcher)IsNot.not((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><dog/>"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNullSourceInSetSource() {
        Transformation t = new Transformation();
        t.setSource(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNullOutputPropertyName() {
        Transformation t = new Transformation();
        t.addOutputProperty(null, "foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNullOutputPropertyValue() {
        Transformation t = new Transformation();
        t.addOutputProperty("foo", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNullParameterName() {
        Transformation t = new Transformation();
        t.addParameter(null, (Object)"foo");
    }

    @Test(expected=ConfigurationException.class)
    public void shouldTransformTransformerConfigurationException() throws Exception {
        Mockito.when((Object)this.fac.newTransformer((Source)Mockito.any(Source.class))).thenThrow(new Throwable[]{new TransformerConfigurationException()});
        this.t.setFactory(this.fac);
        this.t.transformToString();
    }

    @Test
    public void shouldTransformTransformerException() throws Exception {
        ((Transformer)Mockito.doThrow((Throwable)new TransformerException("foo")).when((Object)this.transformer)).transform((Source)Mockito.any(Source.class), (Result)Mockito.any(Result.class));
        this.t.setFactory(this.fac);
        try {
            this.t.transformToString();
            Assert.fail((String)"should have thrown XMLUnitException");
        }
        catch (XMLUnitException ex) {
            Assert.assertEquals(XMLUnitException.class, ((Object)((Object)ex)).getClass());
        }
    }

    @Test
    public void shouldCallNoArgNewTransformerWithoutStylesheet() throws Exception {
        Transformation t = new Transformation(Input.fromFile((String)"../test-resources/testAnimal.xml").build());
        t.setFactory(this.fac);
        t.transformToString();
        ((TransformerFactory)Mockito.verify((Object)this.fac)).newTransformer();
    }

    @Test
    public void passesThroughOutputProperties() {
        this.t.setFactory(this.fac);
        this.t.addOutputProperty("method", "html");
        this.t.transformToString();
        Properties p = new Properties();
        p.setProperty("method", "html");
        ((Transformer)Mockito.verify((Object)this.transformer)).setOutputProperties(p);
    }

    @Test
    public void clearsOutputProperties() {
        this.t.setFactory(this.fac);
        this.t.addOutputProperty("method", "html");
        this.t.clearOutputProperties();
        this.t.transformToString();
        Properties p = new Properties();
        p.setProperty("method", "html");
        ((Transformer)Mockito.verify((Object)this.transformer, (VerificationMode)Mockito.never())).setOutputProperties(p);
        ((Transformer)Mockito.verify((Object)this.transformer)).setOutputProperties(new Properties());
    }

    @Test
    public void passesThroughParameters() {
        this.t.setFactory(this.fac);
        this.t.addParameter("method", (Object)"html");
        this.t.transformToString();
        ((Transformer)Mockito.verify((Object)this.transformer)).setParameter("method", "html");
    }

    @Test
    public void clearsParameters() {
        this.t.setFactory(this.fac);
        this.t.addParameter("method", (Object)"html");
        this.t.clearParameters();
        this.t.transformToString();
        ((Transformer)Mockito.verify((Object)this.transformer, (VerificationMode)Mockito.never())).setParameter("method", "html");
    }

    @Test
    public void passesThroughURIResolver() {
        URIResolver u = (URIResolver)Mockito.mock(URIResolver.class);
        this.t.setFactory(this.fac);
        this.t.setURIResolver(u);
        this.t.transformToString();
        ((Transformer)Mockito.verify((Object)this.transformer)).setURIResolver(u);
    }

    @Test
    public void passesThroughErrorListener() {
        ErrorListener e = (ErrorListener)Mockito.mock(ErrorListener.class);
        this.t.setFactory(this.fac);
        this.t.setErrorListener(e);
        this.t.transformToString();
        ((Transformer)Mockito.verify((Object)this.transformer)).setErrorListener(e);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRejectNullSourceInTransform() {
        Transformation t = new Transformation();
        t.transformToString();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNullResult() {
        this.t.transformTo(null);
    }
}

