/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlunit.ConfigurationException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.util.Convert;

public class ConvertTest {
    @Mock
    private TransformerFactory tFac;
    @Mock
    private Transformer transformer;
    @Mock
    private DocumentBuilderFactory dFac;
    @Mock
    private DocumentBuilder builder;

    @Before
    public void setupMocks() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.tFac.newTransformer()).thenReturn((Object)this.transformer);
        Mockito.when((Object)this.dFac.newDocumentBuilder()).thenReturn((Object)this.builder);
    }

    private static void convertToInputSourceAndAssert(Source s) throws Exception {
        DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = b.parse(Convert.toInputSource((Source)s));
        ConvertTest.documentAsserts(d);
    }

    private static void documentAsserts(Document d) {
        Assert.assertThat((Object)d, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)d.getDocumentElement().getTagName(), (Matcher)Is.is((Object)"animal"));
    }

    @Test
    public void streamSourceToInputSource() throws Exception {
        ConvertTest.convertToInputSourceAndAssert(new StreamSource(new File("../test-resources/test1.xml")));
    }

    @Test
    public void domSourceToInputSource() throws Exception {
        Document d = ConvertTest.animalDocument();
        ConvertTest.convertToInputSourceAndAssert(new DOMSource(d));
    }

    @Test
    public void saxSourceToInputSource() throws Exception {
        InputSource s = new InputSource(new FileInputStream("../test-resources/test1.xml"));
        ConvertTest.convertToInputSourceAndAssert(new SAXSource(s));
    }

    private static void convertToDocumentAndAssert(Source s) {
        ConvertTest.documentAsserts(Convert.toDocument((Source)s));
    }

    @Test
    public void streamSourceToDocument() throws Exception {
        ConvertTest.convertToDocumentAndAssert(new StreamSource(new File("../test-resources/test1.xml")));
    }

    @Test
    public void domSourceToDocument() throws Exception {
        Document d = ConvertTest.animalDocument();
        ConvertTest.convertToDocumentAndAssert(new DOMSource(d));
        Assert.assertSame((Object)d, (Object)Convert.toDocument((Source)new DOMSource(d)));
    }

    @Test
    public void saxSourceToDocument() throws Exception {
        InputSource s = new InputSource(new FileInputStream("../test-resources/test1.xml"));
        ConvertTest.convertToDocumentAndAssert(new SAXSource(s));
    }

    @Test
    public void domElementToDocument() throws Exception {
        Document d = ConvertTest.animalDocument();
        ConvertTest.convertToDocumentAndAssert(new DOMSource(d.getDocumentElement()));
        Assert.assertNotSame((Object)d, (Object)Convert.toDocument((Source)new DOMSource(d.getDocumentElement())));
    }

    private static void convertToNodeAndAssert(Source s) {
        Node n = Convert.toNode((Source)s);
        Document d = n instanceof Document ? (Document)n : n.getOwnerDocument();
        ConvertTest.documentAsserts(d);
    }

    @Test
    public void streamSourceToNode() throws Exception {
        ConvertTest.convertToNodeAndAssert(new StreamSource(new File("../test-resources/test1.xml")));
    }

    @Test
    public void domSourceToNode() throws Exception {
        Document d = ConvertTest.animalDocument();
        ConvertTest.convertToNodeAndAssert(new DOMSource(d));
        Assert.assertSame((Object)d, (Object)Convert.toNode((Source)new DOMSource(d)));
    }

    private static void convertToNodeWithDocBuilderFactoryAndAssert(Source s) {
        Node n = Convert.toNode((Source)s, (DocumentBuilderFactory)DocumentBuilderFactory.newInstance());
        Document d = n instanceof Document ? (Document)n : n.getOwnerDocument();
        ConvertTest.documentAsserts(d);
    }

    @Test
    public void streamSourceToNodeWithDocBuilderFactory() throws Exception {
        ConvertTest.convertToNodeAndAssert(new StreamSource(new File("../test-resources/test1.xml")));
    }

    @Test
    public void domSourceToNodeWithDocBuilderFactory() throws Exception {
        Document d = ConvertTest.animalDocument();
        ConvertTest.convertToNodeWithDocBuilderFactoryAndAssert(new DOMSource(d));
        Assert.assertSame((Object)d, (Object)Convert.toNode((Source)new DOMSource(d)));
    }

    @Test
    public void saxSourceToNode() throws Exception {
        InputSource s = new InputSource(new FileInputStream("../test-resources/test1.xml"));
        ConvertTest.convertToNodeWithDocBuilderFactoryAndAssert(new SAXSource(s));
    }

    @Test
    public void domElementToNode() throws Exception {
        Document d = ConvertTest.animalDocument();
        ConvertTest.convertToNodeAndAssert(new DOMSource(d));
        Assert.assertSame((Object)d.getDocumentElement(), (Object)Convert.toNode((Source)new DOMSource(d.getDocumentElement())));
    }

    @Test(expected=ConfigurationException.class)
    public void shouldMapTransformerConfigurationException() throws Exception {
        Mockito.when((Object)this.tFac.newTransformer()).thenThrow(new Throwable[]{new TransformerConfigurationException()});
        Convert.toInputSource((Source)new DOMSource(ConvertTest.animalDocument()), (TransformerFactory)this.tFac);
    }

    @Test
    public void shouldMapTransformerException() throws Exception {
        ((Transformer)Mockito.doThrow((Throwable)new TransformerException("foo")).when((Object)this.transformer)).transform((Source)Mockito.any(Source.class), (Result)Mockito.any(Result.class));
        try {
            Convert.toInputSource((Source)new DOMSource(ConvertTest.animalDocument()), (TransformerFactory)this.tFac);
            Assert.fail((String)"should have thrown XMLUnitException");
        }
        catch (XMLUnitException ex) {
            Assert.assertEquals(XMLUnitException.class, ((Object)((Object)ex)).getClass());
        }
    }

    @Test(expected=ConfigurationException.class)
    public void shouldMapParserConfigurationException() throws Exception {
        Mockito.when((Object)this.dFac.newDocumentBuilder()).thenThrow(new Throwable[]{new ParserConfigurationException()});
        Convert.toDocument((Source)new StreamSource(new File("../test-resources/test1.xml")), (DocumentBuilderFactory)this.dFac);
    }

    @Test
    public void shouldMapSAXException() throws Exception {
        ((DocumentBuilder)Mockito.doThrow((Throwable)new SAXException()).when((Object)this.builder)).parse((InputSource)Mockito.any(InputSource.class));
        try {
            Convert.toDocument((Source)new StreamSource(new File("../test-resources/test1.xml")), (DocumentBuilderFactory)this.dFac);
        }
        catch (XMLUnitException ex) {
            Assert.assertEquals(XMLUnitException.class, ((Object)((Object)ex)).getClass());
        }
    }

    @Test
    public void shouldMapIOException() throws Exception {
        ((DocumentBuilder)Mockito.doThrow((Throwable)new IOException()).when((Object)this.builder)).parse((InputSource)Mockito.any(InputSource.class));
        try {
            Convert.toDocument((Source)new StreamSource(new File("../test-resources/test1.xml")), (DocumentBuilderFactory)this.dFac);
        }
        catch (XMLUnitException ex) {
            Assert.assertEquals(XMLUnitException.class, ((Object)((Object)ex)).getClass());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void namespaceContextWontReturnNamespaceForNullPrefix() {
        NamespaceContext ctx = Convert.toNamespaceContext(new HashMap());
        ctx.getNamespaceURI(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void namespaceContextWontReturnPrefixForNullURI() {
        NamespaceContext ctx = Convert.toNamespaceContext(new HashMap());
        ctx.getPrefix(null);
    }

    @Test
    public void namespaceContextReturnsNsUri() {
        NamespaceContext ctx = Convert.toNamespaceContext(new HashMap());
        Assert.assertEquals((Object)"http://www.w3.org/XML/1998/namespace", (Object)ctx.getNamespaceURI("xml"));
    }

    @Test
    public void namespaceContextReturnsNsPrefix() {
        NamespaceContext ctx = Convert.toNamespaceContext(new HashMap());
        Assert.assertEquals((Object)"xml", (Object)ctx.getPrefix("http://www.w3.org/XML/1998/namespace"));
    }

    @Test
    public void namespaceContextReturnsXmlAttributeNsUri() {
        NamespaceContext ctx = Convert.toNamespaceContext(new HashMap());
        Assert.assertEquals((Object)"http://www.w3.org/2000/xmlns/", (Object)ctx.getNamespaceURI("xmlns"));
    }

    @Test
    public void namespaceContextReturnsXmlAttributeNsPrefix() {
        NamespaceContext ctx = Convert.toNamespaceContext(new HashMap());
        Assert.assertEquals((Object)"xmlns", (Object)ctx.getPrefix("http://www.w3.org/2000/xmlns/"));
    }

    @Test
    public void namespaceContextReturnsExpectedNsUri() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        NamespaceContext ctx = Convert.toNamespaceContext(m);
        Assert.assertEquals((Object)"bar", (Object)ctx.getNamespaceURI("foo"));
    }

    @Test
    public void namespaceContextReturnsExpectedPrefix() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        NamespaceContext ctx = Convert.toNamespaceContext(m);
        Assert.assertEquals((Object)"foo", (Object)ctx.getPrefix("bar"));
    }

    @Test
    public void namespaceContextReturnsFirstPrefix() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("foo", "bar");
        m.put("baz", "bar");
        NamespaceContext ctx = Convert.toNamespaceContext(m);
        Assert.assertEquals((Object)"foo", (Object)ctx.getPrefix("bar"));
    }

    @Test
    public void namespaceContextReturnsAllPrefixes() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("foo", "bar");
        m.put("baz", "bar");
        NamespaceContext ctx = Convert.toNamespaceContext(m);
        Assert.assertArrayEquals((Object[])new String[]{"foo", "baz"}, (Object[])ConvertTest.toArray(ctx.getPrefixes("bar")));
    }

    private static Document animalDocument() throws Exception {
        DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return b.parse(new File("../test-resources/test1.xml"));
    }

    private static String[] toArray(Iterator<String> i) {
        ArrayList<String> al = new ArrayList<String>();
        while (i.hasNext()) {
            al.add(i.next());
        }
        return al.toArray(new String[al.size()]);
    }
}

