/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlunit.util.IterableNodeList;

public class IterableNodeListTest {
    @Mock
    private NodeList list;
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    private IterableNodeList il;

    @Before
    public void setupMocks() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.list.getLength()).thenReturn((Object)2);
        Mockito.when((Object)this.list.item(0)).thenReturn((Object)this.node1);
        Mockito.when((Object)this.list.item(1)).thenReturn((Object)this.node2);
        this.il = new IterableNodeList(this.list);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void cantRemoveFromIterator() {
        this.il.iterator().remove();
    }

    @Test
    public void iteratesOverNodes() {
        int i = 0;
        for (Node n : this.il) {
            switch (i) {
                case 0: {
                    Assert.assertSame((Object)this.node1, (Object)n);
                    break;
                }
                case 1: {
                    Assert.assertSame((Object)this.node2, (Object)n);
                    break;
                }
                default: {
                    Assert.fail((String)"there shouldn't be more than 2 nodes");
                }
            }
            ++i;
        }
        Assert.assertEquals((long)2L, (long)i);
    }

    @Test
    public void asListCreatesExpectedList() {
        Assert.assertArrayEquals((Object[])new Node[]{this.node1, this.node2}, (Object[])IterableNodeList.asList((NodeList)this.list).toArray(new Node[2]));
    }
}

