/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.util.IsNullPredicate;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Mapper;
import org.xmlunit.util.Predicate;

public class LinqyTest {
    @Test
    public void castContract() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("");
        Iterable s = Linqy.cast(al);
        Assert.assertTrue((boolean)(s.iterator().next() instanceof String));
    }

    @Test
    public void canRemoveFromMapIterator() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("foo");
        Iterator i = Linqy.map(al, (Mapper)new IdentityMapper()).iterator();
        i.next();
        i.remove();
        Assert.assertEquals((long)0L, (long)al.size());
    }

    @Test
    public void canRemoveFromFilterIterator() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("foo");
        Iterator i = Linqy.filter(al, (Predicate)new IsNotNullPredicate()).iterator();
        i.next();
        i.remove();
        Assert.assertEquals((long)0L, (long)al.size());
    }

    @Test
    public void allShouldReturnTrueOnEmptySequence() {
        Assert.assertTrue((boolean)Linqy.all(new ArrayList(), null));
    }

    @Test
    public void anyShouldReturnFalseOnEmptySequence() {
        Assert.assertFalse((boolean)Linqy.any(new ArrayList(), null));
    }

    @Test
    public void anyContract() {
        Assert.assertTrue((boolean)Linqy.any(Arrays.asList(false, false, true), (Predicate)new IdentityPredicate()));
        Assert.assertTrue((boolean)Linqy.any(Arrays.asList(true, false), (Predicate)new IdentityPredicate()));
        Assert.assertTrue((boolean)Linqy.any(Arrays.asList(true, true), (Predicate)new IdentityPredicate()));
        Assert.assertTrue((boolean)Linqy.any(Arrays.asList(true, true, false), (Predicate)new IdentityPredicate()));
        Assert.assertFalse((boolean)Linqy.any(Arrays.asList(false, false), (Predicate)new IdentityPredicate()));
    }

    @Test
    public void allContract() {
        Assert.assertFalse((boolean)Linqy.all(Arrays.asList(false, false, true), (Predicate)new IdentityPredicate()));
        Assert.assertFalse((boolean)Linqy.all(Arrays.asList(true, false), (Predicate)new IdentityPredicate()));
        Assert.assertTrue((boolean)Linqy.all(Arrays.asList(true, true), (Predicate)new IdentityPredicate()));
        Assert.assertFalse((boolean)Linqy.all(Arrays.asList(true, true, false), (Predicate)new IdentityPredicate()));
        Assert.assertFalse((boolean)Linqy.all(Arrays.asList(false, false), (Predicate)new IdentityPredicate()));
    }

    @Test(expected=NoSuchElementException.class)
    public void cantReadPastFirstElementForSingleton() {
        Iterator i = Linqy.singleton((Object)"foo").iterator();
        i.next();
        i.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void cantRemoveFromSingletonIterator() {
        Iterator i = Linqy.singleton((Object)"foo").iterator();
        i.remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void cantReadPastLastFilterElement() {
        Iterator i = Linqy.filter(Arrays.asList("foo"), (Predicate)new IsNullPredicate()).iterator();
        i.next();
    }

    private class IsNotNullPredicate
    implements Predicate<Object> {
        private IsNotNullPredicate() {
        }

        public boolean test(Object toTest) {
            return toTest != null;
        }
    }

    private static class IdentityMapper
    implements Mapper<Object, Object> {
        private IdentityMapper() {
        }

        public Object apply(Object s) {
            return s;
        }
    }

    private static class IdentityPredicate
    implements Predicate<Boolean> {
        private IdentityPredicate() {
        }

        public boolean test(Boolean b) {
            return b;
        }
    }
}

