/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.util.Nodes;

public class NodesTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String SOME_URI = "urn:some:uri";
    private Document doc;

    @Before
    public void createDoc() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    @Test
    public void qNameOfElementWithNoNs() {
        Element e = this.doc.createElement(FOO);
        QName q = Nodes.getQName((Node)e);
        Assert.assertEquals((Object)FOO, (Object)q.getLocalPart());
        Assert.assertEquals((Object)"", (Object)q.getNamespaceURI());
        Assert.assertEquals((Object)"", (Object)q.getPrefix());
        Assert.assertEquals((Object)new QName(FOO), (Object)q);
    }

    @Test
    public void qNameOfElementWithNsNoPrefix() {
        Element e = this.doc.createElementNS(SOME_URI, FOO);
        QName q = Nodes.getQName((Node)e);
        Assert.assertEquals((Object)FOO, (Object)q.getLocalPart());
        Assert.assertEquals((Object)SOME_URI, (Object)q.getNamespaceURI());
        Assert.assertEquals((Object)"", (Object)q.getPrefix());
        Assert.assertEquals((Object)new QName(SOME_URI, FOO), (Object)q);
    }

    @Test
    public void qNameOfElementWithNsAndPrefix() {
        Element e = this.doc.createElementNS(SOME_URI, FOO);
        e.setPrefix(BAR);
        QName q = Nodes.getQName((Node)e);
        Assert.assertEquals((Object)FOO, (Object)q.getLocalPart());
        Assert.assertEquals((Object)SOME_URI, (Object)q.getNamespaceURI());
        Assert.assertEquals((Object)BAR, (Object)q.getPrefix());
        Assert.assertEquals((Object)new QName(SOME_URI, FOO), (Object)q);
        Assert.assertEquals((Object)new QName(SOME_URI, FOO, BAR), (Object)q);
    }

    @Test
    public void mergeNoTexts() {
        Element e = this.doc.createElement(FOO);
        Assert.assertEquals((Object)"", (Object)Nodes.getMergedNestedText((Node)e));
    }

    @Test
    public void mergeSingleTextNode() {
        Element e = this.doc.createElement(FOO);
        Text t = this.doc.createTextNode(BAR);
        e.appendChild(t);
        Assert.assertEquals((Object)BAR, (Object)Nodes.getMergedNestedText((Node)e));
    }

    @Test
    public void mergeSingleCDATASection() {
        Element e = this.doc.createElement(FOO);
        CDATASection t = this.doc.createCDATASection(BAR);
        e.appendChild(t);
        Assert.assertEquals((Object)BAR, (Object)Nodes.getMergedNestedText((Node)e));
    }

    @Test
    public void mergeIgnoresTextOfChildren() {
        Element e = this.doc.createElement(FOO);
        Element c = this.doc.createElement("child");
        Text t = this.doc.createTextNode(BAR);
        e.appendChild(c);
        c.appendChild(t);
        Assert.assertEquals((Object)"", (Object)Nodes.getMergedNestedText((Node)e));
    }

    @Test
    public void mergeIgnoresComments() {
        Element e = this.doc.createElement(FOO);
        Comment c = this.doc.createComment(BAR);
        e.appendChild(c);
        Assert.assertEquals((Object)"", (Object)Nodes.getMergedNestedText((Node)e));
    }

    @Test
    public void mergeMultipleChildren() {
        Element e = this.doc.createElement(FOO);
        CDATASection c = this.doc.createCDATASection(BAR);
        e.appendChild(c);
        e.appendChild(this.doc.createElement("child"));
        Text t = this.doc.createTextNode(BAR);
        e.appendChild(t);
        Assert.assertEquals((Object)"barbar", (Object)Nodes.getMergedNestedText((Node)e));
    }

    @Test
    public void attributeMapNoAttributes() {
        Element e = this.doc.createElement(FOO);
        Map m = Nodes.getAttributes((Node)e);
        Assert.assertEquals((long)0L, (long)m.size());
    }

    @Test
    public void attributeMapNoNS() {
        Element e = this.doc.createElement(FOO);
        e.setAttribute(FOO, BAR);
        Map m = Nodes.getAttributes((Node)e);
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((Object)BAR, m.get(new QName(FOO)));
    }

    @Test
    public void attributeMapwithNS() {
        Element e = this.doc.createElement(FOO);
        e.setAttributeNS(SOME_URI, FOO, BAR);
        Map m = Nodes.getAttributes((Node)e);
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((Object)BAR, m.get(new QName(SOME_URI, FOO)));
        Assert.assertEquals((Object)BAR, m.get(new QName(SOME_URI, FOO, BAR)));
    }

    private Document handleWsSetup() {
        return Convert.toDocument((Source)Input.fromString((String)"<root>\n<!-- trim\tme -->\n<child attr=' trim me ' attr2='not me'>\n trim me \n</child><![CDATA[ trim me ]]>\n<?target  trim me ?>\n<![CDATA[          ]]>\n</root>").build());
    }

    private Map.Entry<Document, Node> stripWsSetup() {
        final Document toTest = this.handleWsSetup();
        final Node stripped = Nodes.stripWhitespace((Node)toTest);
        return new Map.Entry<Document, Node>(){

            @Override
            public Document getKey() {
                return toTest;
            }

            @Override
            public Node getValue() {
                return stripped;
            }

            @Override
            public Node setValue(Node n) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Map.Entry<Document, Node> normalizeWsSetup() {
        final Document toTest = this.handleWsSetup();
        final Node stripped = Nodes.normalizeWhitespace((Node)toTest);
        return new Map.Entry<Document, Node>(){

            @Override
            public Document getKey() {
                return toTest;
            }

            @Override
            public Node getValue() {
                return stripped;
            }

            @Override
            public Node setValue(Node n) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Test
    public void stripWhitespaceWorks() {
        this.handleWsWorks(this.stripWsSetup(), "trim\tme");
    }

    @Test
    public void normalizeWhitespaceWorks() {
        this.handleWsWorks(this.normalizeWsSetup(), "trim me");
    }

    private void handleWsWorks(Map.Entry<Document, Node> s, String commentContent) {
        Assert.assertTrue((boolean)(s.getValue() instanceof Document));
        NodeList top = s.getValue().getChildNodes();
        Assert.assertEquals((long)1L, (long)top.getLength());
        Assert.assertTrue((boolean)(top.item(0) instanceof Element));
        Assert.assertEquals((Object)"root", (Object)top.item(0).getNodeName());
        NodeList rootsChildren = top.item(0).getChildNodes();
        Assert.assertEquals((long)4L, (long)rootsChildren.getLength());
        Assert.assertTrue((String)("should be comment, is " + rootsChildren.item(0).getClass()), (boolean)(rootsChildren.item(0) instanceof Comment));
        Assert.assertEquals((Object)commentContent, (Object)((Comment)rootsChildren.item(0)).getData());
        Assert.assertTrue((String)("should be element, is " + rootsChildren.item(1).getClass()), (boolean)(rootsChildren.item(1) instanceof Element));
        Assert.assertEquals((Object)"child", (Object)rootsChildren.item(1).getNodeName());
        Assert.assertTrue((String)("should be cdata, is " + rootsChildren.item(2).getClass()), (boolean)(rootsChildren.item(2) instanceof CDATASection));
        Assert.assertEquals((Object)"trim me", (Object)((CDATASection)rootsChildren.item(2)).getData());
        Assert.assertTrue((String)("should be PI, is " + rootsChildren.item(3).getClass()), (boolean)(rootsChildren.item(3) instanceof ProcessingInstruction));
        Assert.assertEquals((Object)"trim me", (Object)((ProcessingInstruction)rootsChildren.item(3)).getData());
        Node child = rootsChildren.item(1);
        NodeList grandChildren = child.getChildNodes();
        Assert.assertEquals((long)1L, (long)grandChildren.getLength());
        Assert.assertTrue((String)("should be text, is " + grandChildren.item(0).getClass()), (boolean)(grandChildren.item(0) instanceof Text));
        Assert.assertEquals((Object)"trim me", (Object)((Text)grandChildren.item(0)).getData());
        NamedNodeMap attrs = child.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.getLength());
        Attr a = (Attr)attrs.getNamedItem("attr");
        Assert.assertEquals((Object)"trim me", (Object)a.getValue());
        Attr a2 = (Attr)attrs.getNamedItem("attr2");
        Assert.assertEquals((Object)"not me", (Object)a2.getValue());
    }

    @Test
    public void stripWhitespaceDoesntAlterOriginal() {
        this.handleWsDoesntAlterOriginal(this.stripWsSetup());
    }

    @Test
    public void normalizeWhitespaceDoesntAlterOriginal() {
        this.handleWsDoesntAlterOriginal(this.normalizeWsSetup());
    }

    private void handleWsDoesntAlterOriginal(Map.Entry<Document, Node> s) {
        NodeList top = s.getKey().getChildNodes();
        Assert.assertEquals((long)1L, (long)top.getLength());
        Assert.assertTrue((boolean)(top.item(0) instanceof Element));
        Assert.assertEquals((Object)"root", (Object)top.item(0).getNodeName());
        NodeList rootsChildren = top.item(0).getChildNodes();
        Assert.assertEquals((long)10L, (long)rootsChildren.getLength());
        NodesTest.assertNewlineTextNode(rootsChildren.item(0));
        Assert.assertTrue((String)("should be comment, is " + rootsChildren.item(1).getClass()), (boolean)(rootsChildren.item(1) instanceof Comment));
        Assert.assertEquals((Object)" trim\tme ", (Object)((Comment)rootsChildren.item(1)).getData());
        NodesTest.assertNewlineTextNode(rootsChildren.item(2));
        Assert.assertTrue((String)("should be element, is " + rootsChildren.item(3).getClass()), (boolean)(rootsChildren.item(3) instanceof Element));
        Assert.assertEquals((Object)"child", (Object)rootsChildren.item(3).getNodeName());
        Assert.assertTrue((String)("should be cdata, is " + rootsChildren.item(4).getClass()), (boolean)(rootsChildren.item(4) instanceof CDATASection));
        Assert.assertEquals((Object)" trim me ", (Object)((CDATASection)rootsChildren.item(4)).getData());
        NodesTest.assertNewlineTextNode(rootsChildren.item(5));
        Assert.assertTrue((String)("should be PI, is " + rootsChildren.item(6).getClass()), (boolean)(rootsChildren.item(6) instanceof ProcessingInstruction));
        Assert.assertEquals((Object)"trim me ", (Object)((ProcessingInstruction)rootsChildren.item(6)).getData());
        NodesTest.assertNewlineTextNode(rootsChildren.item(7));
        Assert.assertTrue((String)("should be cdata, is " + rootsChildren.item(8).getClass()), (boolean)(rootsChildren.item(8) instanceof CDATASection));
        Assert.assertEquals((Object)"          ", (Object)((CDATASection)rootsChildren.item(8)).getData());
        NodesTest.assertNewlineTextNode(rootsChildren.item(9));
        Node child = rootsChildren.item(3);
        NodeList grandChildren = child.getChildNodes();
        Assert.assertEquals((long)1L, (long)grandChildren.getLength());
        Assert.assertTrue((String)("should be text, is " + grandChildren.item(0).getClass()), (boolean)(grandChildren.item(0) instanceof Text));
        Assert.assertEquals((Object)"\n trim me \n", (Object)((Text)grandChildren.item(0)).getData());
        NamedNodeMap attrs = child.getAttributes();
        Assert.assertEquals((long)2L, (long)attrs.getLength());
        Attr a = (Attr)attrs.getNamedItem("attr");
        Assert.assertEquals((Object)" trim me ", (Object)a.getValue());
        Attr a2 = (Attr)attrs.getNamedItem("attr2");
        Assert.assertEquals((Object)"not me", (Object)a2.getValue());
    }

    private static void assertNewlineTextNode(Node n) {
        Assert.assertTrue((String)("should be text, is " + n.getClass()), (boolean)(n instanceof Text));
        Assert.assertEquals((Object)"\n", (Object)((Text)n).getData());
    }

    @Test
    public void normalize() {
        Assert.assertSame((Object)FOO, (Object)Nodes.normalize((String)FOO));
        Assert.assertSame((Object)"foo bar", (Object)Nodes.normalize((String)"foo bar"));
        Assert.assertEquals((Object)"foo bar", (Object)Nodes.normalize((String)"foo\nbar"));
        Assert.assertEquals((Object)"foo bar", (Object)Nodes.normalize((String)"foo  \r\n\t bar"));
    }
}

