/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;
import org.xmlunit.XMLUnitException;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ValidationResult;

public class JAXPValidatorTest {
    private static final File BOOK_XSD = new File("../test-resources/Book.xsd");
    @Mock
    private SchemaFactory fac;
    @Mock
    private Schema schema;
    @Mock
    private Validator validator;

    @Before
    public void setupMocks() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.fac.newSchema((Source[])Mockito.any(Source[].class))).thenReturn((Object)this.schema);
        Mockito.when((Object)this.fac.newSchema()).thenReturn((Object)this.schema);
        Mockito.when((Object)this.schema.newValidator()).thenReturn((Object)this.validator);
    }

    @Test
    public void shouldSuccessfullyValidateSchema() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        ValidationResult r = v.validateSchema();
        Assert.assertTrue((boolean)r.isValid());
        Assert.assertFalse((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldSuccessfullyValidateInstance() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGenerated.xml")));
        Assert.assertTrue((boolean)r.isValid());
        Assert.assertFalse((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldSuccessfullyValidateInstanceWithoutSchemaSource() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGeneratedWithFixedSchemaLocation.xml")));
        Assert.assertTrue((boolean)r.isValid());
        Assert.assertFalse((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldFailOnBrokenSchema() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/broken.xsd")));
        ValidationResult r = v.validateSchema();
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldFailOnBrokenInstance() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/invalidBook.xml")));
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldThrowWhenValidatingInstanceAndSchemaIsInvalid() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/broken.xsd")));
        try {
            v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGenerated.xml")));
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)IsInstanceOf.instanceOf(XMLUnitException.class));
        }
    }

    @Test
    public void shouldThrowWhenValidatingInstanceAndSchemaIsNotThere() {
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/foo.xsd")));
        try {
            v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGenerated.xml")));
            Assert.fail((String)"should have thrown an exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)IsInstanceOf.instanceOf(XMLUnitException.class));
        }
    }

    @Test
    public void validateSchemaTranslatesSAXParseExceptionIntoValidationError() throws Exception {
        Mockito.when((Object)this.fac.newSchema((Source[])Mockito.any(Source[].class))).thenThrow(new Throwable[]{new SAXParseException("foo", new LocatorImpl())});
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema", this.fac);
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        ValidationResult r = v.validateSchema();
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test(expected=XMLUnitException.class)
    public void validateSchemaTranslatesSAXException() throws Exception {
        Mockito.when((Object)this.fac.newSchema((Source[])Mockito.any(Source[].class))).thenThrow(new Throwable[]{new SAXException()});
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema", this.fac);
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        v.validateSchema();
    }

    @Test
    public void validateInstanceTranslatesSAXParseExceptionIntoValidationError() throws Exception {
        ((Validator)Mockito.doThrow((Throwable)new SAXParseException("foo", new LocatorImpl())).when((Object)this.validator)).validate((Source)Mockito.any(Source.class));
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema", this.fac);
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGenerated.xml")));
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test(expected=XMLUnitException.class)
    public void validateInstanceTranslatesSAXException() throws Exception {
        ((Validator)Mockito.doThrow((Throwable)new SAXException()).when((Object)this.validator)).validate((Source)Mockito.any(Source.class));
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema", this.fac);
        v.setSchemaSource((Source)new StreamSource(BOOK_XSD));
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGenerated.xml")));
    }
}

