/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;
import org.xmlunit.ConfigurationException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.validation.ParsingValidator;
import org.xmlunit.validation.ValidationResult;

public class ParsingValidatorTest {
    @Mock
    private SAXParserFactory fac;
    @Mock
    private SAXParser parser;

    @Before
    public void setupMocks() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.fac.newSAXParser()).thenReturn((Object)this.parser);
    }

    @Test
    public void shouldSuccessfullyValidateSchemaInstance() {
        ParsingValidator v = new ParsingValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.xsd")));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/BookXsdGenerated.xml")));
        Assert.assertTrue((boolean)r.isValid());
        Assert.assertFalse((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldFailOnBrokenSchemaInstance() {
        ParsingValidator v = new ParsingValidator("http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.xsd")));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/invalidBook.xml")));
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldSuccessfullyValidateDTDInstance() {
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.dtd")));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")));
        Assert.assertTrue((boolean)r.isValid());
        Assert.assertFalse((boolean)r.getProblems().iterator().hasNext());
    }

    @Test
    public void shouldFailOnBrokenDTDInstance() {
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.dtd")));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/invalidBookWithDoctype.xml")));
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectRelaxNG() {
        new ParsingValidator("http://relaxng.org/ns/structure/1.0");
    }

    @Test(expected=XMLUnitException.class)
    public void shouldNotAllowSchemaValidation() {
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.dtd")));
        v.validateSchema();
    }

    @Test
    public void shouldTranslateSAXParseExceptionDuringParseToValidationError() throws Exception {
        ((SAXParser)Mockito.doThrow((Throwable)new SAXParseException("foo", new LocatorImpl())).when((Object)this.parser)).parse((InputSource)Mockito.any(InputSource.class), (DefaultHandler)Mockito.any(DefaultHandler.class));
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.dtd")));
        ValidationResult r = v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
    }

    @Test(expected=XMLUnitException.class)
    public void shouldMapSAXExceptionDuringParse() throws Exception {
        ((SAXParser)Mockito.doThrow((Throwable)new SAXException()).when((Object)this.parser)).parse((InputSource)Mockito.any(InputSource.class), (DefaultHandler)Mockito.any(DefaultHandler.class));
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.setSchemaSource((Source)new StreamSource(new File("../test-resources/Book.dtd")));
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
    }

    @Test(expected=XMLUnitException.class)
    public void shouldMapSAXException() throws Exception {
        Mockito.when((Object)this.fac.newSAXParser()).thenThrow(new Throwable[]{new SAXException()});
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
    }

    @Test(expected=ConfigurationException.class)
    public void shouldMapParserConfigurationException() throws Exception {
        Mockito.when((Object)this.fac.newSAXParser()).thenThrow(new Throwable[]{new ParserConfigurationException()});
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
    }

    @Test(expected=ConfigurationException.class)
    public void shouldMapSAXNotRecognizedException() throws Exception {
        ((SAXParser)Mockito.doThrow((Throwable)new SAXNotRecognizedException()).when((Object)this.parser)).setProperty(Mockito.anyString(), Mockito.any());
        ParsingValidator v = new ParsingValidator("http://www.w3.org/2001/XMLSchema");
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
    }

    @Test(expected=ConfigurationException.class)
    public void shouldMapSAXNotSupportedException() throws Exception {
        ((SAXParser)Mockito.doThrow((Throwable)new SAXNotSupportedException()).when((Object)this.parser)).setProperty(Mockito.anyString(), Mockito.any());
        ParsingValidator v = new ParsingValidator("http://www.w3.org/2001/XMLSchema");
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
    }

    @Test(expected=XMLUnitException.class)
    public void shouldMapIOException() throws Exception {
        ((SAXParser)Mockito.doThrow((Throwable)new IOException()).when((Object)this.parser)).parse((InputSource)Mockito.any(InputSource.class), (DefaultHandler)Mockito.any(DefaultHandler.class));
        ParsingValidator v = new ParsingValidator("http://www.w3.org/TR/REC-xml");
        v.validateInstance((Source)new StreamSource(new File("../test-resources/BookWithDoctype.xml")), this.fac);
    }
}

