/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;
import org.xmlunit.validation.ValidationHandler;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;

public class ValidationHandlerTest {
    private ValidationHandler handler = new ValidationHandler();

    @Test
    public void errorIsAProblem() {
        this.handler.error(new SAXParseException("foo", new LocatorImpl()));
        ValidationResult r = this.handler.getResult();
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
        ValidationProblem p = (ValidationProblem)r.getProblems().iterator().next();
        Assert.assertEquals((Object)ValidationProblem.ProblemType.ERROR, (Object)p.getType());
    }

    @Test
    public void fatalErrorIsAProblem() {
        this.handler.fatalError(new SAXParseException("foo", new LocatorImpl()));
        ValidationResult r = this.handler.getResult();
        Assert.assertFalse((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
        ValidationProblem p = (ValidationProblem)r.getProblems().iterator().next();
        Assert.assertEquals((Object)ValidationProblem.ProblemType.ERROR, (Object)p.getType());
    }

    @Test
    public void worningIsAProblemButDoesntInvalidateResult() {
        this.handler.warning(new SAXParseException("foo", new LocatorImpl()));
        ValidationResult r = this.handler.getResult();
        Assert.assertTrue((boolean)r.isValid());
        Assert.assertTrue((boolean)r.getProblems().iterator().hasNext());
        ValidationProblem p = (ValidationProblem)r.getProblems().iterator().next();
        Assert.assertEquals((Object)ValidationProblem.ProblemType.WARNING, (Object)p.getType());
    }

    @Test
    public void shouldIgnoreErrorThatHasBeenReportedAsFatalAlready() {
        SAXParseException ex = new SAXParseException("foo", new LocatorImpl());
        this.handler.fatalError(ex);
        this.handler.error(ex);
        ValidationResult r = this.handler.getResult();
        Assert.assertFalse((boolean)r.isValid());
        Iterator problems = r.getProblems().iterator();
        problems.next();
        Assert.assertFalse((boolean)problems.hasNext());
    }

    @Test
    public void shouldRecordErrorThatIsDifferentFromPreviousFatalAlready() {
        SAXParseException ex = new SAXParseException("foo", new LocatorImpl());
        this.handler.fatalError(ex);
        this.handler.error(new SAXParseException("foo", new LocatorImpl()));
        ValidationResult r = this.handler.getResult();
        Assert.assertFalse((boolean)r.isValid());
        Iterator problems = r.getProblems().iterator();
        problems.next();
        Assert.assertTrue((boolean)problems.hasNext());
    }
}

