/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;
import org.xmlunit.validation.ValidationProblem;

public class ValidationProblemTest {
    @Test
    public void trivialGetterTests() {
        ValidationProblem p = new ValidationProblem("foo", 1, 2, ValidationProblem.ProblemType.ERROR);
        Assert.assertEquals((Object)"foo", (Object)p.getMessage());
        Assert.assertEquals((long)1L, (long)p.getLine());
        Assert.assertEquals((long)2L, (long)p.getColumn());
        Assert.assertEquals((Object)ValidationProblem.ProblemType.ERROR, (Object)p.getType());
    }

    @Test
    public void trivialToStringTest() {
        ValidationProblem p = new ValidationProblem("foo", 1, 2, ValidationProblem.ProblemType.ERROR);
        String s = p.toString();
        Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"line=1"));
        Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"column=2"));
        Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"type=ERROR"));
        Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"message='foo'"));
    }

    @Test
    public void shouldSubstituteUNKNOWNForUnknownLocations() {
        ValidationProblem p = ValidationProblem.fromException((SAXParseException)new SAXParseException("foo", new LocatorImpl()), (ValidationProblem.ProblemType)ValidationProblem.ProblemType.ERROR);
        Assert.assertEquals((long)-1L, (long)p.getLine());
        Assert.assertEquals((long)-1L, (long)p.getColumn());
    }
}

