/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import javax.xml.transform.Source;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ParsingValidator;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class ValidatorTest {
    @Test
    public void shouldReturnEmptyArrayForNullSchemaSources() {
        Validator v = new Validator(){

            public Source[] getSchemaSources() {
                return super.getSchemaSources();
            }

            public ValidationResult validateInstance(Source s) {
                return null;
            }

            public ValidationResult validateSchema() {
                return null;
            }
        };
        v.setSchemaSources((Source[])null);
        Assert.assertNotNull((Object)v.getSchemaSources());
        Assert.assertEquals((long)0L, (long)v.getSchemaSources().length);
    }

    @Test
    public void shouldUseJAXPForXMLSchema() {
        Assert.assertTrue((boolean)(Validator.forLanguage((String)"http://www.w3.org/2001/XMLSchema") instanceof JAXPValidator));
    }

    @Test
    public void shouldUseParsingForDTD() {
        Assert.assertTrue((boolean)(Validator.forLanguage((String)"http://www.w3.org/TR/REC-xml") instanceof ParsingValidator));
    }
}

