/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.xpath;

import java.io.File;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.Input;
import org.xmlunit.xpath.XPathEngine;

public abstract class AbstractXPathEngineTest {
    private Source source;
    private DocumentBuilder db;
    private Element sourceRootElement;

    protected abstract XPathEngine getEngine();

    @Before
    public void readSource() throws Exception {
        this.source = Input.fromFile((String)"../test-resources/test.blame.html").build();
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(true);
        this.db = f.newDocumentBuilder();
        this.sourceRootElement = this.db.parse(new File("../test-resources/test.blame.html")).getDocumentElement();
    }

    @Test
    public void selectNodesWithNoMatches() {
        Iterable i = this.getEngine().selectNodes("foo", this.source);
        Assert.assertNotNull((Object)i);
        Assert.assertFalse((boolean)i.iterator().hasNext());
    }

    @Test
    public void selectNodesWithSingleMatch() {
        Iterable i = this.getEngine().selectNodes("//ul", this.source);
        Assert.assertNotNull((Object)i);
        Iterator it = i.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"ul", (Object)((Node)it.next()).getNodeName());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void selectNodesWithMultipleMatchs() {
        Iterable i = this.getEngine().selectNodes("//li", this.source);
        Assert.assertNotNull((Object)i);
        int count = 0;
        Iterator it = i.iterator();
        while (it.hasNext()) {
            ++count;
            Assert.assertEquals((Object)"li", (Object)((Node)it.next()).getNodeName());
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test(expected=XMLUnitException.class)
    public void selectNodesWithInvalidXPath() {
        this.getEngine().selectNodes("//li[", this.source);
    }

    @Test
    public void evaluateWithNoMatches() {
        Assert.assertEquals((Object)"", (Object)this.getEngine().evaluate("foo", this.source));
    }

    @Test
    public void evaluateWithSingleMatch() {
        Assert.assertEquals((Object)"Don't blame it on the...", (Object)this.getEngine().evaluate("//title", this.source));
    }

    @Test
    public void evaluateWithSingleMatchTextSelector() {
        Assert.assertEquals((Object)"Don't blame it on the...", (Object)this.getEngine().evaluate("//title/text()", this.source));
    }

    @Test
    public void evaluateWithMultipleMatches() {
        Assert.assertEquals((Object)"sunshine", (Object)this.getEngine().evaluate("//li", this.source));
    }

    @Test(expected=XMLUnitException.class)
    public void evaluateWithInvalidXPath() {
        this.getEngine().evaluate("//li[", this.source);
    }

    @Test
    public void selectNodesWithNS() {
        XPathEngine e = this.getEngine();
        this.source = Input.fromString((String)"<n:d xmlns:n='urn:test:1'><n:e/></n:d>").build();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("x", "urn:test:1");
        e.setNamespaceContext(m);
        Iterable it = e.selectNodes("/x:d/x:e", this.source);
        Assert.assertTrue((boolean)it.iterator().hasNext());
    }

    @Test
    public void selectNodesWithDefaultNS() {
        XPathEngine e = this.getEngine();
        this.source = Input.fromString((String)"<d xmlns='urn:test:1'><e/></d>").build();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("x", "urn:test:1");
        e.setNamespaceContext(m);
        Iterable it = e.selectNodes("/x:d/x:e", this.source);
        Assert.assertTrue((boolean)it.iterator().hasNext());
    }

    @Test
    public void selectNodesWithDefaultNSEmptyPrefix() {
        XPathEngine e = this.getEngine();
        this.source = Input.fromString((String)"<d xmlns='urn:test:1'><e/></d>").build();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("", "urn:test:1");
        e.setNamespaceContext(m);
        Iterable it = e.selectNodes("/:d/:e", this.source);
        Assert.assertTrue((boolean)it.iterator().hasNext());
    }

    @Test
    public void selectNodesWithNoMatches_NodeVersion() {
        Iterable i = this.getEngine().selectNodes("foo", (Node)this.sourceRootElement);
        Assert.assertNotNull((Object)i);
        Assert.assertFalse((boolean)i.iterator().hasNext());
    }

    @Test
    public void selectNodesWithSingleMatch_NodeVersion() {
        Iterable i = this.getEngine().selectNodes("//ul", (Node)this.sourceRootElement);
        Assert.assertNotNull((Object)i);
        Iterator it = i.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"ul", (Object)((Node)it.next()).getNodeName());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void selectNodesWithMultipleMatchs_NodeVersion() {
        Iterable i = this.getEngine().selectNodes("//li", (Node)this.sourceRootElement);
        Assert.assertNotNull((Object)i);
        int count = 0;
        Iterator it = i.iterator();
        while (it.hasNext()) {
            ++count;
            Assert.assertEquals((Object)"li", (Object)((Node)it.next()).getNodeName());
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test(expected=XMLUnitException.class)
    public void selectNodesWithInvalidXPath_NodeVersion() {
        this.getEngine().selectNodes("//li[", (Node)this.sourceRootElement);
    }

    @Test
    public void evaluateWithNoMatches_NodeVersion() {
        Assert.assertEquals((Object)"", (Object)this.getEngine().evaluate("foo", (Node)this.sourceRootElement));
    }

    @Test
    public void evaluateWithSingleMatch_NodeVersion() {
        Assert.assertEquals((Object)"Don't blame it on the...", (Object)this.getEngine().evaluate("//title", (Node)this.sourceRootElement));
    }

    @Test
    public void evaluateWithSingleMatchTextSelector_NodeVersion() {
        Assert.assertEquals((Object)"Don't blame it on the...", (Object)this.getEngine().evaluate("//title/text()", (Node)this.sourceRootElement));
    }

    @Test
    public void evaluateWithMultipleMatches_NodeVersion() {
        Assert.assertEquals((Object)"sunshine", (Object)this.getEngine().evaluate("//li", (Node)this.sourceRootElement));
    }

    @Test(expected=XMLUnitException.class)
    public void evaluateWithInvalidXPath_NodeVersion() {
        this.getEngine().evaluate("//li[", (Node)this.sourceRootElement);
    }

    @Test
    public void selectNodesWithNS_NodeVersion() throws Exception {
        XPathEngine e = this.getEngine();
        this.sourceRootElement = this.db.parse(new StringBufferInputStream("<n:d xmlns:n='urn:test:1'><n:e/></n:d>")).getDocumentElement();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("x", "urn:test:1");
        e.setNamespaceContext(m);
        Iterable it = e.selectNodes("/x:d/x:e", (Node)this.sourceRootElement);
        Assert.assertTrue((boolean)it.iterator().hasNext());
    }

    @Test
    public void selectNodesWithDefaultNS_NodeVersion() throws Exception {
        XPathEngine e = this.getEngine();
        this.sourceRootElement = this.db.parse(new StringBufferInputStream("<d xmlns='urn:test:1'><e/></d>")).getDocumentElement();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("x", "urn:test:1");
        e.setNamespaceContext(m);
        Iterable it = e.selectNodes("/x:d/x:e", (Node)this.sourceRootElement);
        Assert.assertTrue((boolean)it.iterator().hasNext());
    }

    @Test
    public void selectNodesWithDefaultNSEmptyPrefix_NodeVersion() throws Exception {
        XPathEngine e = this.getEngine();
        this.sourceRootElement = this.db.parse(new StringBufferInputStream("<d xmlns='urn:test:1'><e/></d>")).getDocumentElement();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("", "urn:test:1");
        e.setNamespaceContext(m);
        Iterable it = e.selectNodes("/:d/:e", (Node)this.sourceRootElement);
        Assert.assertTrue((boolean)it.iterator().hasNext());
    }
}

