/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.xtext.gradle.GradleExtensions;
import org.xtext.gradle.XtextBuilderPluginVersion;
import org.xtext.gradle.XtextJavaLanguagePlugin;
import org.xtext.gradle.tasks.GeneratorConfig;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.Outlet;
import org.xtext.gradle.tasks.XtextBuilderOptions;
import org.xtext.gradle.tasks.XtextClasspathInferrer;
import org.xtext.gradle.tasks.XtextEclipseSettings;
import org.xtext.gradle.tasks.XtextExtension;
import org.xtext.gradle.tasks.XtextGenerate;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.XtextSourceSetOutputs;

public class XtextBuilderPlugin
implements Plugin<Project> {
    private Project project;
    private XtextExtension xtext;
    private Configuration xtextLanguages;

    public void apply(Project project) {
        Configuration _create_1;
        XtextExtension _create;
        this.project = project;
        PluginContainer _plugins = project.getPlugins();
        _plugins.apply(BasePlugin.class);
        ExtensionContainer _extensions = project.getExtensions();
        this.xtext = _create = (XtextExtension)_extensions.create("xtext", XtextExtension.class, new Object[]{project});
        ConfigurationContainer _configurations = project.getConfigurations();
        this.xtextLanguages = _create_1 = (Configuration)_configurations.create("xtextLanguages");
        this.xtext.makeXtextCompatible(this.xtextLanguages);
        this.automaticallyInferXtextCoreClasspath();
        this.createGeneratorTasks();
        this.configureOutletDefaults();
        this.addSourceSetIncludes();
        this.integrateWithJavaPlugin();
        this.integrateWithEclipsePlugin();
    }

    private void createGeneratorTasks() {
        NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets = this.xtext.getSourceSets();
        Action _function = sourceSet -> {
            TaskContainer _tasks = this.project.getTasks();
            String _generatorTaskName = sourceSet.getGeneratorTaskName();
            Action _function_1 = it -> {
                it.setSources((XtextSourceDirectorySet)sourceSet);
                XtextSourceSetOutputs _output = sourceSet.getOutput();
                it.setSourceSetOutputs(_output);
                NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
                it.setLanguages((Set<Language>)_languages);
                final XtextGenerate generate = it;
                abstract class __XtextBuilderPlugin_1
                implements Callable<FileCollection> {
                    FileCollection inferredClasspath;

                    __XtextBuilderPlugin_1() {
                    }
                }
                __XtextBuilderPlugin_1 ___XtextBuilderPlugin_1 = new __XtextBuilderPlugin_1((XtextSourceDirectorySet)sourceSet){
                    final /* synthetic */ XtextSourceDirectorySet val$sourceSet;
                    {
                        this.val$sourceSet = xtextSourceDirectorySet;
                    }

                    @Override
                    public FileCollection call() throws Exception {
                        FileCollection _xblockexpression = null;
                        if (this.inferredClasspath == null) {
                            FileCollection _inferXtextClasspath;
                            FileCollection _classpath = generate.getClasspath();
                            this.inferredClasspath = _inferXtextClasspath = XtextBuilderPlugin.this.inferXtextClasspath(this.val$sourceSet, _classpath);
                        }
                        _xblockexpression = this.inferredClasspath;
                        return _xblockexpression;
                    }
                };
                ConfigurableFileCollection _files = this.project.files(new Object[]{___XtextBuilderPlugin_1});
                it.setXtextClasspath((FileCollection)_files);
            };
            _tasks.create(_generatorTaskName, XtextGenerate.class, _function_1);
            TaskContainer _tasks_1 = this.project.getTasks();
            String _generatorTaskName_1 = sourceSet.getGeneratorTaskName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_generatorTaskName_1);
            String _plus = "clean" + _firstUpper;
            Action _function_2 = it -> {
                final Functions.Function1 _function_3 = it_1 -> {
                    NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
                    Functions.Function1 _function_4 = it_2 -> {
                        GeneratorConfig _generator = it_2.getGenerator();
                        return _generator.getOutlets();
                    };
                    Iterable _map = IterableExtensions.map(_languages, (Functions.Function1)_function_4);
                    Iterable _flatten = Iterables.concat((Iterable)_map);
                    Functions.Function1 _function_5 = it_2 -> it_2.isCleanAutomatically();
                    Iterable _filter = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_5);
                    Functions.Function1 _function_6 = it_2 -> {
                        XtextSourceSetOutputs _output = sourceSet.getOutput();
                        return _output.getDir((Outlet)it_2);
                    };
                    Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_6);
                    return IterableExtensions.toSet((Iterable)_map_1);
                };
                it.delete(new Object[]{new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() {
                        return (Set)_function_3.apply(null);
                    }
                }});
            };
            _tasks_1.create(_plus, Delete.class, _function_2);
        };
        _sourceSets.all(_function);
    }

    private FileCollection inferXtextClasspath(XtextSourceDirectorySet sourceSet, FileCollection classpath) {
        List<XtextClasspathInferrer> _classpathInferrers = this.xtext.getClasspathInferrers();
        Functions.Function2 _function = (newXextClasspath, inferrer) -> inferrer.inferXtextClasspath(sourceSet, (FileCollection)newXextClasspath, classpath);
        return (FileCollection)IterableExtensions.fold(_classpathInferrers, (Object)this.xtextLanguages, (Functions.Function2)_function);
    }

    private boolean automaticallyInferXtextCoreClasspath() {
        List<XtextClasspathInferrer> _classpathInferrers = this.xtext.getClasspathInferrers();
        return _classpathInferrers.add(new XtextClasspathInferrer(){

            @Override
            public FileCollection inferXtextClasspath(XtextSourceDirectorySet sourceSet, final FileCollection xtextClasspath, final FileCollection classpath) {
                DependencyHandler _dependencies = XtextBuilderPlugin.this.project.getDependencies();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"org.xtext:xtext-gradle-builder:");
                _builder.append((Object)XtextBuilderPluginVersion.PLUGIN_VERSION, "");
                Dependency xtextBuilder = GradleExtensions.externalModule(_dependencies, _builder.toString());
                ConfigurationContainer _configurations = XtextBuilderPlugin.this.project.getConfigurations();
                String _qualifyConfigurationName = sourceSet.qualifyConfigurationName("xtextTooling");
                Configuration xtextTooling = (Configuration)_configurations.create(_qualifyConfigurationName);
                DependencySet _dependencies_1 = xtextTooling.getDependencies();
                _dependencies_1.add((Object)xtextBuilder);
                XtextBuilderPlugin.this.xtext.makeXtextCompatible(xtextTooling);
                abstract class ____XtextBuilderPlugin_1
                implements Functions.Function0<String> {
                    String version;

                    ____XtextBuilderPlugin_1() {
                    }
                }
                ____XtextBuilderPlugin_1 _____XtextBuilderPlugin_1 = new ____XtextBuilderPlugin_1(){
                    {
                        this.version = null;
                    }

                    public String apply() {
                        String _xblockexpression = null;
                        if (this.version == null) {
                            String _xtextVersion_1;
                            String _elvis = null;
                            String _xtextVersion = XtextBuilderPlugin.this.xtext.getXtextVersion(classpath);
                            _elvis = _xtextVersion != null ? _xtextVersion : (_xtextVersion_1 = XtextBuilderPlugin.this.xtext.getXtextVersion(xtextClasspath));
                            this.version = _elvis;
                            if (this.version == null) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"Could not infer Xtext classpath, because xtext.version was not set and no xtext libraries were found on the ");
                                _builder.append((Object)classpath, "");
                                _builder.append((Object)" classpath");
                                throw new GradleException(_builder.toString());
                            }
                        }
                        _xblockexpression = this.version;
                        return _xblockexpression;
                    }
                };
                XtextBuilderPlugin.this.xtext.forceXtextVersion(xtextTooling, _____XtextBuilderPlugin_1);
                FileCollection result = xtextTooling.plus(xtextClasspath);
                return result;
            }
        });
    }

    private void configureOutletDefaults() {
        NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
        Action _function = language -> {
            GeneratorConfig _generator = language.getGenerator();
            NamedDomainObjectContainer<Outlet> _outlets = _generator.getOutlets();
            _outlets.create("DEFAULT_OUTPUT");
            GeneratorConfig _generator_1 = language.getGenerator();
            NamedDomainObjectContainer<Outlet> _outlets_1 = _generator_1.getOutlets();
            Action _function_1 = outlet -> {
                NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets = this.xtext.getSourceSets();
                Action _function_2 = sourceSet -> {
                    XtextSourceSetOutputs output = sourceSet.getOutput();
                    StringConcatenation _builder = new StringConcatenation();
                    File _buildDir = this.project.getBuildDir();
                    _builder.append((Object)_buildDir, "");
                    _builder.append((Object)"/");
                    String _name = language.getName();
                    _builder.append((Object)_name, "");
                    String _folderFragment = outlet.getFolderFragment();
                    _builder.append((Object)_folderFragment, "");
                    _builder.append((Object)"/");
                    String _name_1 = sourceSet.getName();
                    _builder.append((Object)_name_1, "");
                    output.dir((Outlet)outlet, _builder);
                };
                _sourceSets.all(_function_2);
            };
            _outlets_1.all(_function_1);
        };
        _languages.all(_function);
    }

    private void addSourceSetIncludes() {
        Action _function = it -> {
            NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
            Action _function_1 = lang -> {
                NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets = this.xtext.getSourceSets();
                Action _function_2 = it_1 -> {
                    PatternFilterable _filter = it_1.getFilter();
                    String _fileExtension = lang.getFileExtension();
                    String _plus = "**/*." + _fileExtension;
                    _filter.include(new String[]{_plus});
                };
                _sourceSets.all(_function_2);
            };
            _languages.all(_function_1);
        };
        this.project.afterEvaluate(_function);
    }

    private DomainObjectCollection<JavaBasePlugin> integrateWithJavaPlugin() {
        PluginContainer _plugins = this.project.getPlugins();
        Action _function = it -> {
            Action _function_1 = it_1 -> it_1.plugin(XtextJavaLanguagePlugin.class);
            this.project.apply(_function_1);
            Convention _convention = this.project.getConvention();
            JavaPluginConvention java = (JavaPluginConvention)_convention.findPlugin(JavaPluginConvention.class);
            NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
            Action _function_2 = it_1 -> {
                Action _function_3 = p -> {
                    GeneratorConfig _generator = it_1.getGenerator();
                    String _elvis = null;
                    GeneratorConfig _generator_1 = it_1.getGenerator();
                    String _javaSourceLevel = _generator_1.getJavaSourceLevel();
                    if (_javaSourceLevel != null) {
                        _elvis = _javaSourceLevel;
                    } else {
                        String _majorVersion;
                        JavaVersion _sourceCompatibility = java.getSourceCompatibility();
                        _elvis = _majorVersion = _sourceCompatibility.getMajorVersion();
                    }
                    _generator.setJavaSourceLevel(_elvis);
                };
                this.project.afterEvaluate(_function_3);
            };
            _languages.all(_function_2);
            SourceSetContainer _sourceSets = java.getSourceSets();
            Action _function_3 = javaSourceSet -> {
                TaskContainer _tasks = this.project.getTasks();
                String _compileJavaTaskName = javaSourceSet.getCompileJavaTaskName();
                Task _byName = _tasks.getByName(_compileJavaTaskName);
                final JavaCompile javaCompile = (JavaCompile)_byName;
                NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets_1 = this.xtext.getSourceSets();
                String _name = javaSourceSet.getName();
                XtextSourceDirectorySet _maybeCreate = (XtextSourceDirectorySet)_sourceSets_1.maybeCreate(_name);
                Procedures.Procedure1 _function_4 = xtextSourceSet -> {
                    TaskContainer _tasks_1 = this.project.getTasks();
                    String _generatorTaskName = xtextSourceSet.getGeneratorTaskName();
                    Task _byName_1 = _tasks_1.getByName(_generatorTaskName);
                    final XtextGenerate generatorTask = (XtextGenerate)_byName_1;
                    Action _function_5 = p -> {
                        FileCollection _compileClasspath;
                        boolean _not;
                        Set<File> _srcDirs = xtextSourceSet.getSrcDirs();
                        Consumer<File> _function_6 = it_1 -> {
                            SourceDirectorySet _allSource = javaSourceSet.getAllSource();
                            _allSource.srcDir(it_1);
                        };
                        _srcDirs.forEach(_function_6);
                        SourceDirectorySet _java = javaSourceSet.getJava();
                        Set _srcDirs_1 = _java.getSrcDirs();
                        Consumer<File> _function_7 = it_1 -> xtextSourceSet.srcDir(it_1);
                        _srcDirs_1.forEach(_function_7);
                        SourceDirectorySet _resources = javaSourceSet.getResources();
                        Set _srcDirs_2 = _resources.getSrcDirs();
                        Consumer<File> _function_8 = it_1 -> xtextSourceSet.srcDir(it_1);
                        _srcDirs_2.forEach(_function_8);
                        NamedDomainObjectContainer<Language> _languages_1 = this.xtext.getLanguages();
                        Functions.Function1 _function_9 = it_1 -> {
                            GeneratorConfig _generator = it_1.getGenerator();
                            return _generator.getOutlets();
                        };
                        Iterable _map = IterableExtensions.map(_languages_1, (Functions.Function1)_function_9);
                        Iterable _flatten = Iterables.concat((Iterable)_map);
                        Functions.Function1 _function_10 = it_1 -> it_1.isProducesJava();
                        Iterable javaOutlets = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_10);
                        Consumer<Outlet> _function_11 = it_1 -> {
                            SourceDirectorySet _java_1 = javaSourceSet.getJava();
                            XtextSourceSetOutputs _output = xtextSourceSet.getOutput();
                            File _dir = _output.getDir((Outlet)it_1);
                            _java_1.srcDir((Object)_dir);
                        };
                        javaOutlets.forEach(_function_11);
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)javaOutlets);
                        boolean bl = _not = !_isEmpty;
                        if (_not) {
                            javaCompile.dependsOn(new Object[]{generatorTask});
                            javaCompile.doLast((Action)new Action<Task>(){

                                public void execute(Task it) {
                                    File _destinationDir = javaCompile.getDestinationDir();
                                    generatorTask.installDebugInfo(_destinationDir);
                                }
                            });
                        }
                        XtextBuilderOptions _options = generatorTask.getOptions();
                        String _elvis = null;
                        XtextBuilderOptions _options_1 = generatorTask.getOptions();
                        String _encoding = _options_1.getEncoding();
                        if (_encoding != null) {
                            _elvis = _encoding;
                        } else {
                            String _encoding_1;
                            CompileOptions _options_2 = javaCompile.getOptions();
                            _elvis = _encoding_1 = _options_2.getEncoding();
                        }
                        _options.setEncoding(_elvis);
                        FileCollection _elvis_1 = null;
                        FileCollection _classpath = generatorTask.getClasspath();
                        _elvis_1 = _classpath != null ? _classpath : (_compileClasspath = javaSourceSet.getCompileClasspath());
                        generatorTask.setClasspath(_elvis_1);
                        FileCollection _elvis_2 = null;
                        FileCollection _bootstrapClasspath = generatorTask.getBootstrapClasspath();
                        if (_bootstrapClasspath != null) {
                            _elvis_2 = _bootstrapClasspath;
                        } else {
                            FileCollection _bootstrapClasspath_1;
                            CompileOptions _options_3 = javaCompile.getOptions();
                            _elvis_2 = _bootstrapClasspath_1 = _options_3.getBootstrapClasspath();
                        }
                        generatorTask.setBootstrapClasspath(_elvis_2);
                    };
                    this.project.afterEvaluate(_function_5);
                };
                ObjectExtensions.operator_doubleArrow((Object)_maybeCreate, (Procedures.Procedure1)_function_4);
            };
            _sourceSets.all(_function_3);
        };
        return _plugins.withType(JavaBasePlugin.class, _function);
    }

    private DomainObjectCollection<EclipsePlugin> integrateWithEclipsePlugin() {
        PluginContainer _plugins = this.project.getPlugins();
        Action _function = it -> {
            TaskContainer _tasks = this.project.getTasks();
            XtextEclipseSettings settingsTask = (XtextEclipseSettings)_tasks.create("xtextEclipseSettings", XtextEclipseSettings.class);
            NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
            settingsTask.setLanguages((Set<Language>)_languages);
            NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets = this.xtext.getSourceSets();
            settingsTask.setSourceSets((Set<XtextSourceDirectorySet>)_sourceSets);
            TaskContainer _tasks_1 = this.project.getTasks();
            Task _at = _tasks_1.getAt("eclipse");
            _at.dependsOn(new Object[]{settingsTask});
            TaskContainer _tasks_2 = this.project.getTasks();
            Task _at_1 = _tasks_2.getAt("cleanEclipse");
            _at_1.dependsOn(new Object[]{"cleanXtextEclipseSettings"});
            ExtensionContainer _extensions = this.project.getExtensions();
            EclipseModel eclipse = (EclipseModel)_extensions.getByType(EclipseModel.class);
            EclipseProject _project = eclipse.getProject();
            _project.buildCommand("org.eclipse.xtext.ui.shared.xtextBuilder");
            EclipseProject _project_1 = eclipse.getProject();
            _project_1.natures(new String[]{"org.eclipse.xtext.ui.shared.xtextNature"});
        };
        return _plugins.withType(EclipsePlugin.class, _function);
    }
}

