/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.file.FileCollection;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.XtextClasspathInferrer;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.internal.DefaultXtextSourceDirectorySet;

public class XtextExtension {
    @Accessors
    private String version;
    @Accessors
    private final NamedDomainObjectContainer<XtextSourceDirectorySet> sourceSets;
    @Accessors
    private final NamedDomainObjectContainer<Language> languages;
    @Accessors
    private final List<XtextClasspathInferrer> classpathInferrers;
    private Project project;
    private static final Pattern LIB_PATTERN = Pattern.compile("org\\.eclipse\\.xtext\\..*-(\\d.*?).jar");

    public XtextExtension(Project project) {
        ArrayList _newArrayList;
        NamedDomainObjectContainer _container_1;
        NamedDomainObjectContainer _container;
        this.project = project;
        NamedDomainObjectFactory _function = name -> new DefaultXtextSourceDirectorySet(name, project, this);
        this.sourceSets = _container = project.container(XtextSourceDirectorySet.class, _function);
        NamedDomainObjectFactory _function_1 = name -> new Language(name, project);
        this.languages = _container_1 = project.container(Language.class, _function_1);
        this.classpathInferrers = _newArrayList = Lists.newArrayList();
    }

    public void sourceSets(Action<? super NamedDomainObjectContainer<XtextSourceDirectorySet>> configureAction) {
        configureAction.execute(this.sourceSets);
    }

    public void languages(Action<? super NamedDomainObjectContainer<Language>> configureAction) {
        configureAction.execute(this.languages);
    }

    public String getXtextVersion(FileCollection classpath) {
        if (this.version != null) {
            return this.version;
        }
        for (File file : classpath) {
            String _name = file.getName();
            Matcher matcher = LIB_PATTERN.matcher(_name);
            boolean _matches = matcher.matches();
            if (!_matches) continue;
            return matcher.group(1);
        }
        return null;
    }

    public void forceXtextVersion(Configuration dependencies, Functions.Function0<? extends String> xtextVersion) {
        ResolutionStrategy _resolutionStrategy = dependencies.getResolutionStrategy();
        Action _function = it -> {
            boolean _or = false;
            ModuleVersionSelector _requested = it.getRequested();
            String _group = _requested.getGroup();
            boolean _equals = Objects.equal((Object)_group, (Object)"org.eclipse.xtext");
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                ModuleVersionSelector _requested_1 = it.getRequested();
                String _group_1 = _requested_1.getGroup();
                _or = _equals_1 = Objects.equal((Object)_group_1, (Object)"org.eclipse.xtend");
            }
            if (_or) {
                String _apply = (String)xtextVersion.apply();
                it.useVersion(_apply);
            }
        };
        _resolutionStrategy.eachDependency(_function);
    }

    public void makeXtextCompatible(Configuration dependencies) {
        Pair _mappedTo = Pair.of((Object)"group", (Object)"asm");
        dependencies.exclude(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
        ResolutionStrategy _resolutionStrategy = dependencies.getResolutionStrategy();
        Action _function = it -> {
            boolean _and = false;
            ModuleVersionSelector _requested = it.getRequested();
            String _group = _requested.getGroup();
            boolean _equals = Objects.equal((Object)_group, (Object)"com.google.inject");
            if (!_equals) {
                _and = false;
            } else {
                boolean _equals_1;
                ModuleVersionSelector _requested_1 = it.getRequested();
                String _name = _requested_1.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)"guice");
            }
            if (_and) {
                it.useVersion("4.0");
            }
        };
        _resolutionStrategy.eachDependency(_function);
    }

    @Pure
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Pure
    public NamedDomainObjectContainer<XtextSourceDirectorySet> getSourceSets() {
        return this.sourceSets;
    }

    @Pure
    public NamedDomainObjectContainer<Language> getLanguages() {
        return this.languages;
    }

    @Pure
    public List<XtextClasspathInferrer> getClasspathInferrers() {
        return this.classpathInferrers;
    }
}

