/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.xtext.gradle.protocol.GradleBuildRequest;
import org.xtext.gradle.protocol.GradleBuildResponse;
import org.xtext.gradle.protocol.GradleGeneratorConfig;
import org.xtext.gradle.protocol.GradleInstallDebugInfoRequest;
import org.xtext.gradle.protocol.GradleOutputConfig;
import org.xtext.gradle.protocol.IncrementalXtextBuilder;
import org.xtext.gradle.protocol.IssueSeverity;
import org.xtext.gradle.tasks.DebuggerConfig;
import org.xtext.gradle.tasks.GeneratedAnnotationOptions;
import org.xtext.gradle.tasks.GeneratorConfig;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.Outlet;
import org.xtext.gradle.tasks.ValidatorConfig;
import org.xtext.gradle.tasks.XtextBuilderOptions;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.XtextSourceSetOutputs;
import org.xtext.gradle.tasks.internal.IncrementalXtextBuilderProvider;

public class XtextGenerate
extends DefaultTask {
    @Internal
    @Accessors
    private XtextSourceDirectorySet sources;
    @Nested
    @Accessors
    private Set<Language> languages;
    @Classpath
    @Accessors
    private FileCollection xtextClasspath;
    @Classpath
    @Optional
    @Accessors
    private FileCollection classpath;
    @Classpath
    @Optional
    @Accessors
    private FileCollection bootstrapClasspath;
    @Internal
    @Accessors
    private XtextSourceSetOutputs sourceSetOutputs;
    @Nested
    @Accessors
    private final XtextBuilderOptions options = new XtextBuilderOptions();
    private IncrementalXtextBuilder builder;
    private Collection<File> generatedFiles;

    @InputFiles
    public FileTree getAllSources() {
        return this.sources.getFiles();
    }

    @InputFiles
    @SkipWhenEmpty
    public FileTree getMainSources() {
        FileTree _xblockexpression = null;
        PatternSet patterns = new PatternSet();
        Functions.Function1 _function = it -> {
            GeneratorConfig _generator = it.getGenerator();
            NamedDomainObjectContainer<Outlet> _outlets = _generator.getOutlets();
            boolean _isEmpty = _outlets.isEmpty();
            return !_isEmpty;
        };
        Iterable _filter = IterableExtensions.filter(this.languages, (Functions.Function1)_function);
        Consumer<Language> _function_1 = lang -> {
            String _fileExtension = lang.getFileExtension();
            String _plus = "**/*." + _fileExtension;
            patterns.include(new String[]{_plus});
        };
        _filter.forEach(_function_1);
        Project _project = this.getProject();
        Set<File> _srcDirs = this.sources.getSrcDirs();
        ConfigurableFileCollection _files = _project.files(new Object[]{_srcDirs});
        FileTree _asFileTree = _files.getAsFileTree();
        _xblockexpression = _asFileTree.matching((PatternFilterable)patterns);
        return _xblockexpression;
    }

    @OutputDirectories
    public Iterable<File> getOutputDirectories() {
        Functions.Function1 _function = it -> {
            GeneratorConfig _generator = it.getGenerator();
            NamedDomainObjectContainer<Outlet> _outlets = _generator.getOutlets();
            Functions.Function1 _function_1 = it_1 -> {
                boolean _isCleanAutomatically = it_1.isCleanAutomatically();
                return _isCleanAutomatically;
            };
            return IterableExtensions.exists(_outlets, (Functions.Function1)_function_1);
        };
        Iterable buildContinuousLanguages = IterableExtensions.filter(this.languages, (Functions.Function1)_function);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new File[0]);
        for (Language l : buildContinuousLanguages) {
            GeneratorConfig _generator = l.getGenerator();
            NamedDomainObjectContainer<Outlet> _outlets = _generator.getOutlets();
            for (Outlet o : _outlets) {
                File _dir = this.sourceSetOutputs.getDir(o);
                result.add(_dir);
            }
        }
        Functions.Function1 _function_1 = it -> it != null;
        return IterableExtensions.filter((Iterable)result, (Functions.Function1)_function_1);
    }

    @TaskAction
    public Collection<File> generate(IncrementalTaskInputs inputs) {
        Collection _generatedFiles;
        HashSet _newHashSet;
        Collection _xblockexpression = null;
        this.generatedFiles = _newHashSet = CollectionLiterals.newHashSet((Object[])new File[0]);
        this.initializeBuilder();
        GradleBuildRequest request = this.createBuildRequest();
        this.addIncrementalInputs(request, inputs);
        GradleBuildResponse response = this.builder.build(request);
        _xblockexpression = this.generatedFiles = (_generatedFiles = response.getGeneratedFiles());
        return _xblockexpression;
    }

    private GradleBuildRequest createBuildRequest() {
        GradleBuildRequest _gradleBuildRequest = new GradleBuildRequest();
        Procedures.Procedure1 _function = it -> {
            Project _project = this.getProject();
            String _name = _project.getName();
            it.setProjectName(_name);
            Project _project_1 = this.getProject();
            File _projectDir = _project_1.getProjectDir();
            it.setProjectDir(_projectDir);
            String _containerHandle = this.getContainerHandle();
            it.setContainerHandle(_containerHandle);
            FileTree _allSources = this.getAllSources();
            Set _files = _allSources.getFiles();
            it.setAllFiles((Collection)_files);
            FileCollection _nullSafeClasspath = this.getNullSafeClasspath();
            Set _files_1 = _nullSafeClasspath.getFiles();
            it.setAllClasspathEntries((Collection)_files_1);
            it.setBootstrapClasspath(this.bootstrapClasspath);
            Set<File> _srcDirs = this.sources.getSrcDirs();
            it.setSourceFolders(_srcDirs);
            Functions.Function1 _function_1 = it_1 -> it_1.getQualifiedName();
            Map _map = IterableExtensions.toMap(this.languages, (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it_1 -> {
                GradleGeneratorConfig _xblockexpression = null;
                GeneratorConfig config = it_1.getGenerator();
                GradleGeneratorConfig _gradleGeneratorConfig = new GradleGeneratorConfig();
                Procedures.Procedure1 _function_3 = it_2 -> {
                    boolean _isSuppressWarningsAnnotation = config.isSuppressWarningsAnnotation();
                    it_2.setGenerateSyntheticSuppressWarnings(_isSuppressWarningsAnnotation);
                    GeneratedAnnotationOptions _generatedAnnotation = config.getGeneratedAnnotation();
                    boolean _isActive = _generatedAnnotation.isActive();
                    it_2.setGenerateGeneratedAnnotation(_isActive);
                    GeneratedAnnotationOptions _generatedAnnotation_1 = config.getGeneratedAnnotation();
                    boolean _isIncludeDate = _generatedAnnotation_1.isIncludeDate();
                    it_2.setIncludeDateInGeneratedAnnotation(_isIncludeDate);
                    GeneratedAnnotationOptions _generatedAnnotation_2 = config.getGeneratedAnnotation();
                    String _comment = _generatedAnnotation_2.getComment();
                    it_2.setGeneratedAnnotationComment(_comment);
                    String _elvis = null;
                    String _javaSourceLevel = config.getJavaSourceLevel();
                    if (_javaSourceLevel != null) {
                        _elvis = _javaSourceLevel;
                    } else {
                        String _majorVersion;
                        JavaVersion _current = JavaVersion.current();
                        _elvis = _majorVersion = _current.getMajorVersion();
                    }
                    JavaVersion _version = JavaVersion.toVersion((Object)_elvis);
                    it_2.setJavaSourceLevel(_version);
                    NamedDomainObjectContainer<Outlet> _outlets = config.getOutlets();
                    Functions.Function1 _function_4 = outlet -> {
                        GradleOutputConfig _gradleOutputConfig = new GradleOutputConfig();
                        Procedures.Procedure1 _function_5 = it_3 -> {
                            String _name_1 = outlet.getName();
                            it_3.setOutletName(_name_1);
                            File _dir = this.sourceSetOutputs.getDir((Outlet)outlet);
                            it_3.setTarget(_dir);
                            boolean _isCleanAutomatically = outlet.isCleanAutomatically();
                            it_3.setCleanAutomatically(_isCleanAutomatically);
                        };
                        return (GradleOutputConfig)ObjectExtensions.operator_doubleArrow((Object)_gradleOutputConfig, (Procedures.Procedure1)_function_5);
                    };
                    Iterable _map_1 = IterableExtensions.map(_outlets, (Functions.Function1)_function_4);
                    Set _set = IterableExtensions.toSet((Iterable)_map_1);
                    it_2.setOutputConfigs(_set);
                };
                _xblockexpression = (GradleGeneratorConfig)ObjectExtensions.operator_doubleArrow((Object)_gradleGeneratorConfig, (Procedures.Procedure1)_function_3);
                return _xblockexpression;
            };
            Map _mapValues = MapExtensions.mapValues((Map)_map, (Functions.Function1)_function_2);
            it.setGeneratorConfigsByLanguage(_mapValues);
            Functions.Function1 _function_3 = it_1 -> it_1.getQualifiedName();
            Map _map_1 = IterableExtensions.toMap(this.languages, (Functions.Function1)_function_3);
            Functions.Function1 _function_4 = it_1 -> {
                HashMap _xblockexpression = null;
                HashMap allPreferences = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                Map<String, Object> _preferences = it_1.getPreferences();
                Functions.Function1 _function_5 = it_2 -> it_2.toString();
                Map _mapValues_1 = MapExtensions.mapValues(_preferences, (Functions.Function1)_function_5);
                allPreferences.putAll(_mapValues_1);
                ValidatorConfig _validator = it_1.getValidator();
                Map<String, IssueSeverity> _severities = _validator.getSeverities();
                Functions.Function1 _function_6 = it_2 -> it_2.toString();
                Map _mapValues_2 = MapExtensions.mapValues(_severities, (Functions.Function1)_function_6);
                allPreferences.putAll(_mapValues_2);
                _xblockexpression = allPreferences;
                return _xblockexpression;
            };
            Map _mapValues_1 = MapExtensions.mapValues((Map)_map_1, (Functions.Function1)_function_4);
            it.setPreferencesByLanguage(_mapValues_1);
            Logger _logger = this.getLogger();
            it.setLogger(_logger);
        };
        return (GradleBuildRequest)ObjectExtensions.operator_doubleArrow((Object)_gradleBuildRequest, (Procedures.Procedure1)_function);
    }

    private void addIncrementalInputs(GradleBuildRequest request, IncrementalTaskInputs inputs) {
        boolean _isIncremental_1;
        boolean _and = false;
        boolean _isIncremental = this.options.isIncremental();
        _and = !_isIncremental ? false : (_isIncremental_1 = inputs.isIncremental());
        request.setIncremental(_and);
        Action _function = it -> {
            File _file_2;
            FileCollection _nullSafeClasspath;
            boolean _contains_1;
            File _file;
            FileTree _allSources = this.getAllSources();
            boolean _contains = _allSources.contains(_file = it.getFile());
            if (_contains) {
                Collection _dirtyFiles = request.getDirtyFiles();
                File _file_1 = it.getFile();
                _dirtyFiles.add(_file_1);
            }
            if (_contains_1 = (_nullSafeClasspath = this.getNullSafeClasspath()).contains(_file_2 = it.getFile())) {
                Collection _dirtyClasspathEntries = request.getDirtyClasspathEntries();
                File _file_3 = it.getFile();
                _dirtyClasspathEntries.add(_file_3);
            }
        };
        inputs.outOfDate(_function);
        Action _function_1 = it -> {
            File _file;
            FileTree _allSources = this.getAllSources();
            boolean _contains = _allSources.contains(_file = it.getFile());
            if (_contains) {
                Collection _deletedFiles = request.getDeletedFiles();
                File _file_1 = it.getFile();
                _deletedFiles.add(_file_1);
            }
        };
        inputs.removed(_function_1);
    }

    public void installDebugInfo(File classesDir) {
        FileTree _mainSources = this.getMainSources();
        boolean _isEmpty = _mainSources.isEmpty();
        if (_isEmpty) {
            return;
        }
        this.initializeBuilder();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.generatedFiles);
        if (_isNullOrEmpty) {
            List _list;
            XtextSourceSetOutputs _sourceSetOutputs = this.getSourceSetOutputs();
            FileCollection _dirs = _sourceSetOutputs.getDirs();
            Functions.Function1 _function = dir -> {
                Project _project = this.getProject();
                return _project.fileTree(dir);
            };
            Iterable _map = IterableExtensions.map((Iterable)_dirs, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            this.generatedFiles = _list = IterableExtensions.toList((Iterable)_flatten);
        }
        GradleInstallDebugInfoRequest _gradleInstallDebugInfoRequest = new GradleInstallDebugInfoRequest();
        Procedures.Procedure1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> {
                String _name = it_1.getName();
                return _name.endsWith(".java");
            };
            Iterable _filter = IterableExtensions.filter(this.generatedFiles, (Functions.Function1)_function_2);
            Set _set = IterableExtensions.toSet((Iterable)_filter);
            it.setGeneratedJavaFiles((Collection)_set);
            it.setClassesDir(classesDir);
            Functions.Function1 _function_3 = it_1 -> it_1.getFileExtension();
            Map _map_1 = IterableExtensions.toMap(this.languages, (Functions.Function1)_function_3);
            Functions.Function1 _function_4 = lang -> {
                GradleInstallDebugInfoRequest.GradleSourceInstallerConfig _gradleSourceInstallerConfig = new GradleInstallDebugInfoRequest.GradleSourceInstallerConfig();
                Procedures.Procedure1 _function_5 = it_1 -> {
                    DebuggerConfig _debugger = lang.getDebugger();
                    GradleInstallDebugInfoRequest.SourceInstaller _sourceInstaller = _debugger.getSourceInstaller();
                    it_1.setSourceInstaller(_sourceInstaller);
                    DebuggerConfig _debugger_1 = lang.getDebugger();
                    boolean _isHideSyntheticVariables = _debugger_1.isHideSyntheticVariables();
                    it_1.setHideSyntheticVariables(_isHideSyntheticVariables);
                };
                return (GradleInstallDebugInfoRequest.GradleSourceInstallerConfig)ObjectExtensions.operator_doubleArrow((Object)_gradleSourceInstallerConfig, (Procedures.Procedure1)_function_5);
            };
            Map _mapValues = MapExtensions.mapValues((Map)_map_1, (Functions.Function1)_function_4);
            it.setSourceInstallerByFileExtension(_mapValues);
        };
        GradleInstallDebugInfoRequest request = (GradleInstallDebugInfoRequest)ObjectExtensions.operator_doubleArrow((Object)_gradleInstallDebugInfoRequest, (Procedures.Procedure1)_function_1);
        this.builder.installDebugInfo(request);
    }

    private IncrementalXtextBuilder initializeBuilder() {
        IncrementalXtextBuilder _builder;
        Set<String> _languageSetups = this.getLanguageSetups();
        String _nullSafeEncoding = this.getNullSafeEncoding();
        Set _files = this.xtextClasspath.getFiles();
        this.builder = _builder = IncrementalXtextBuilderProvider.getBuilder(_languageSetups, _nullSafeEncoding, _files);
        return this.builder;
    }

    private String getContainerHandle() {
        Project _project = this.getProject();
        File _projectDir = _project.getProjectDir();
        String _plus = _projectDir + ":";
        String _name = this.sources.getName();
        return _plus + _name;
    }

    private FileCollection getNullSafeClasspath() {
        FileCollection _elvis = null;
        if (this.classpath != null) {
            _elvis = this.classpath;
        } else {
            Project _project = this.getProject();
            ConfigurableFileCollection _files = _project.files(new Object[0]);
            _elvis = _files;
        }
        return _elvis;
    }

    private String getNullSafeEncoding() {
        String _name;
        String _elvis = null;
        String _encoding = this.options.getEncoding();
        _elvis = _encoding != null ? _encoding : (_name = Charsets.UTF_8.name());
        return _elvis;
    }

    private Set<String> getLanguageSetups() {
        Functions.Function1 _function = it -> it.getSetup();
        Iterable _map = IterableExtensions.map(this.languages, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_map);
    }

    @Pure
    public XtextSourceDirectorySet getSources() {
        return this.sources;
    }

    public void setSources(XtextSourceDirectorySet sources) {
        this.sources = sources;
    }

    @Pure
    public Set<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Set<Language> languages) {
        this.languages = languages;
    }

    @Pure
    public FileCollection getXtextClasspath() {
        return this.xtextClasspath;
    }

    public void setXtextClasspath(FileCollection xtextClasspath) {
        this.xtextClasspath = xtextClasspath;
    }

    @Pure
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Pure
    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection bootstrapClasspath) {
        this.bootstrapClasspath = bootstrapClasspath;
    }

    @Pure
    public XtextSourceSetOutputs getSourceSetOutputs() {
        return this.sourceSetOutputs;
    }

    public void setSourceSetOutputs(XtextSourceSetOutputs sourceSetOutputs) {
        this.sourceSetOutputs = sourceSetOutputs;
    }

    @Pure
    public XtextBuilderOptions getOptions() {
        return this.options;
    }
}

