/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import junitparams.FileParameters;
import junitparams.Parameters;
import junitparams.internal.parameters.ParametrizationStrategy;
import junitparams.mappers.DataMapper;
import org.junit.runners.model.FrameworkMethod;

class ParametersFromFile
implements ParametrizationStrategy {
    private FrameworkMethod frameworkMethod;

    ParametersFromFile(FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
    }

    @Override
    public Object[] getParameters() {
        return this.paramsFromFile((FileParameters)this.frameworkMethod.getAnnotation(FileParameters.class));
    }

    @Override
    public boolean isApplicable() {
        return this.frameworkMethod.getAnnotation(Parameters.class) == null && this.frameworkMethod.getAnnotation(FileParameters.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] paramsFromFile(FileParameters fileParametersAnnotation) {
        Object[] objectArray;
        Reader reader = this.createProperReader(fileParametersAnnotation);
        DataMapper mapper = fileParametersAnnotation.mapper().newInstance();
        try {
            objectArray = mapper.map(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not successfully read parameters from file: " + fileParametersAnnotation.value(), e);
            }
        }
        reader.close();
        return objectArray;
    }

    private Reader createProperReader(FileParameters fileParametersAnnotation) throws IOException {
        String filepath = fileParametersAnnotation.value();
        if (filepath.indexOf(58) < 0) {
            return new FileReader(filepath);
        }
        String protocol = filepath.substring(0, filepath.indexOf(58));
        String filename = filepath.substring(filepath.indexOf(58) + 1);
        if ("classpath".equals(protocol)) {
            return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(filename));
        }
        if ("file".equals(protocol)) {
            return new FileReader(filename);
        }
        throw new IllegalArgumentException("Unknown file access protocol. Only 'file' and 'classpath' are supported!");
    }
}

