/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.FieldsSavingRequestWrapper;

public class Context {
    private static final ThreadLocal<Context> CURRENT = new InheritableThreadLocal<Context>();
    private WroConfiguration wroConfig;
    private transient HttpServletRequest request;
    private transient HttpServletResponse response;
    private transient ServletContext servletContext;
    private transient FilterConfig filterConfig;
    private String aggregatedFolderPath;

    public WroConfiguration getConfig() {
        return this.wroConfig;
    }

    public void setConfig(WroConfiguration config) {
        this.wroConfig = config;
    }

    public static Context webContext(HttpServletRequest request, HttpServletResponse response, FilterConfig filterConfig) {
        return new Context(request, response, filterConfig);
    }

    public static Context standaloneContext() {
        return new Context();
    }

    public static Context get() {
        Context.validateContext();
        return CURRENT.get();
    }

    public static boolean isContextSet() {
        return CURRENT.get() != null;
    }

    private static void validateContext() {
        if (CURRENT.get() == null) {
            throw new WroRuntimeException("No context associated with CURRENT request cycle!");
        }
    }

    public static void set(Context context) {
        Context.set(context, new WroConfiguration());
    }

    public static void set(Context context, WroConfiguration config) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)config);
        CURRENT.set(context);
        CURRENT.get().setConfig(config);
    }

    public static void unset() {
        CURRENT.remove();
    }

    private Context() {
    }

    private Context(HttpServletRequest request, HttpServletResponse response, FilterConfig filterConfig) {
        this.request = new FieldsSavingRequestWrapper(request);
        this.response = response;
        this.servletContext = filterConfig != null ? filterConfig.getServletContext() : null;
        this.filterConfig = filterConfig;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public String getAggregatedFolderPath() {
        return this.aggregatedFolderPath;
    }

    public void setAggregatedFolderPath(String aggregatedFolderPath) {
        this.aggregatedFolderPath = aggregatedFolderPath;
    }

    public static void destroy() {
        Context.unset();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

