/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.factory;

import java.util.Properties;
import javax.servlet.FilterConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.util.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterConfigWroConfigurationFactory
implements ObjectFactory<WroConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(FilterConfigWroConfigurationFactory.class);
    public static final String PARAM_CONFIGURATION = "configuration";
    @Deprecated
    public static final String PARAM_VALUE_DEPLOYMENT = "DEPLOYMENT";
    FilterConfig filterConfig;

    public FilterConfigWroConfigurationFactory(FilterConfig filterConfig) {
        Validate.notNull((Object)filterConfig);
        this.filterConfig = filterConfig;
    }

    protected Properties initProperties() {
        return this.createPropertiesFromFilterConfig();
    }

    protected final Properties createPropertiesFromFilterConfig() {
        Properties props = new Properties();
        for (ConfigConstants config : ConfigConstants.values()) {
            String value = this.filterConfig.getInitParameter(config.name());
            if (value == null) continue;
            LOG.debug("filterConfig initParam ({}), with value ({})", (Object)config.name(), (Object)value);
            props.setProperty(config.name(), value);
        }
        String configurationType = this.filterConfig.getInitParameter(PARAM_CONFIGURATION);
        if (!StringUtils.isEmpty((CharSequence)configurationType)) {
            props.setProperty(ConfigConstants.debug.name(), String.valueOf(this.isDebug(configurationType)));
        }
        return props;
    }

    private boolean isDebug(String configurationType) {
        return !PARAM_VALUE_DEPLOYMENT.equalsIgnoreCase(configurationType);
    }

    @Override
    public WroConfiguration create() {
        PropertyWroConfigurationFactory factory = new PropertyWroConfigurationFactory();
        factory.setProperties(this.initProperties());
        return factory.create();
    }
}

