/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.factory.FilterConfigWroConfigurationFactory;

public class PropertiesAndFilterConfigWroConfigurationFactory
extends FilterConfigWroConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesAndFilterConfigWroConfigurationFactory.class);
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "wro.properties";

    public PropertiesAndFilterConfigWroConfigurationFactory(FilterConfig filterConfig) {
        super(filterConfig);
    }

    protected InputStream newPropertyStream() throws IOException {
        return PropertiesAndFilterConfigWroConfigurationFactory.defaultConfigPropertyStream(this.filterConfig);
    }

    public static InputStream defaultConfigPropertyStream(FilterConfig filterConfig) {
        Validate.notNull((Object)filterConfig);
        return filterConfig.getServletContext().getResourceAsStream("/WEB-INF/wro.properties");
    }

    public Properties initProperties() {
        Properties merged = new Properties();
        try {
            InputStream propertyStream = this.newPropertyStream();
            if (propertyStream != null) {
                Properties props = new Properties();
                props.load(propertyStream);
                merged.putAll((Map<?, ?>)props);
            } else {
                LOG.debug("No Properties stream found, proceeding with reading init-params");
            }
        }
        catch (IOException e) {
            LOG.error("Cannot read properties file stream", (Throwable)e);
            throw new WroRuntimeException("Invalid properties file provided", e);
        }
        Properties props = this.createPropertiesFromFilterConfig();
        merged.putAll((Map<?, ?>)props);
        return merged;
    }
}

