/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.manager.WroManagerFactory;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ConfigurableProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableWroFilter
extends WroFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableWroFilter.class);
    @Deprecated
    private boolean debug = true;
    @Deprecated
    private boolean gzipEnabled = true;
    @Deprecated
    private boolean jmxEnabled = true;
    @Deprecated
    private String mbeanName;
    @Deprecated
    private long cacheUpdatePeriod = 0L;
    @Deprecated
    private long modelUpdatePeriod = 0L;
    @Deprecated
    private boolean disableCache;
    @Deprecated
    private String encoding;
    private Properties properties;

    @Override
    protected ObjectFactory<WroConfiguration> newWroConfigurationFactory() {
        PropertyWroConfigurationFactory factory = new PropertyWroConfigurationFactory();
        if (this.properties == null) {
            this.properties = new Properties();
            this.properties.setProperty(ConfigConstants.debug.name(), String.valueOf(this.debug));
            this.properties.setProperty(ConfigConstants.gzipResources.name(), String.valueOf(this.gzipEnabled));
            this.properties.setProperty(ConfigConstants.jmxEnabled.name(), String.valueOf(this.jmxEnabled));
            this.properties.setProperty(ConfigConstants.cacheUpdatePeriod.name(), String.valueOf(this.cacheUpdatePeriod));
            this.properties.setProperty(ConfigConstants.modelUpdatePeriod.name(), String.valueOf(this.modelUpdatePeriod));
            this.properties.setProperty(ConfigConstants.disableCache.name(), String.valueOf(this.disableCache));
            this.properties.setProperty(ConfigConstants.encoding.name(), String.valueOf(this.encoding));
        }
        factory.setProperties(this.properties);
        return factory;
    }

    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    @Override
    protected String newMBeanName() {
        if (this.mbeanName != null) {
            return this.mbeanName;
        }
        return super.newMBeanName();
    }

    @Override
    protected WroManagerFactory newWroManagerFactory() {
        return new BaseWroManagerFactory(){

            protected ProcessorsFactory newProcessorsFactory() {
                Map<String, ResourcePreProcessor> preProcessorsMap = ProcessorsUtils.createPreProcessorsMap();
                Map<String, ResourcePostProcessor> postProcessorsMap = ProcessorsUtils.createPostProcessorsMap();
                LOG.debug("available preProcessors are: {}", preProcessorsMap.keySet());
                LOG.debug("available postProcessors are: {}", preProcessorsMap.keySet());
                LOG.debug("trying to import processors from extensions module...");
                try {
                    Class<?> clazz = Class.forName("ro.isdc.wro.extensions.manager.ExtensionsConfigurableWroManagerFactory");
                    Method method = clazz.getMethod("pupulateMapWithExtensionsProcessors", Map.class);
                    method.invoke(null, preProcessorsMap);
                    method.invoke(null, postProcessorsMap);
                    LOG.debug("[OK] Extensions processors imported successfully: {}", preProcessorsMap.keySet());
                }
                catch (Exception e) {
                    LOG.debug("[FAIL] Failed to import processors from extensions module", (Throwable)e);
                }
                return new ConfigurableProcessorsFactory().setPreProcessorsMap(preProcessorsMap).setPostProcessorsMap(postProcessorsMap).setProperties(ConfigurableWroFilter.this.properties);
            }
        };
    }

    public void setMbeanName(String mbeanName) {
        this.mbeanName = mbeanName;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public final void setGzipEnabled(boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
    }

    public final void setCacheUpdatePeriod(long cacheUpdatePeriod) {
        this.cacheUpdatePeriod = cacheUpdatePeriod;
    }

    public final void setModelUpdatePeriod(long modelUpdatePeriod) {
        this.modelUpdatePeriod = modelUpdatePeriod;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

