/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.config.factory.PropertiesAndFilterConfigWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.HttpHeader;
import ro.isdc.wro.manager.CacheChangeCallbackAware;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.WroManagerFactory;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(WroFilter.class);
    private static final String MBEAN_PREFIX = "wro4j-";
    private static final String DEFAULT_CACHE_CONTROL_VALUE = "public, max-age=315360000";
    public static final String PATH_API = "wroAPI";
    public static final String API_RELOAD_CACHE = "wroAPI/reloadCache";
    public static final String API_RELOAD_MODEL = "wroAPI/reloadModel";
    private FilterConfig filterConfig;
    private WroConfiguration wroConfiguration;
    private WroManagerFactory wroManagerFactory;
    private final Map<String, String> headersMap = new LinkedHashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            return super.put(key.trim().toLowerCase(), value);
        }

        @Override
        public String get(Object key) {
            return (String)super.get(((String)key).toLowerCase());
        }
    };

    protected ObjectFactory<WroConfiguration> newWroConfigurationFactory() {
        return new PropertiesAndFilterConfigWroConfigurationFactory(this.filterConfig);
    }

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.wroConfiguration = this.newWroConfigurationFactory().create();
        this.initWroManagerFactory();
        this.initHeaderValues();
        this.registerChangeListeners();
        this.initJMX();
        this.doInit(config);
    }

    private void initWroManagerFactory() {
        this.wroManagerFactory = this.getWroManagerFactory();
        if (this.wroManagerFactory instanceof CacheChangeCallbackAware) {
            ((CacheChangeCallbackAware)((Object)this.wroManagerFactory)).registerCallback(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    WroFilter.this.initHeaderValues();
                }
            });
        }
    }

    private void initJMX() {
        try {
            ObjectName name;
            MBeanServer mbeanServer;
            if (this.wroConfiguration.isJmxEnabled() && !(mbeanServer = this.getMBeanServer()).isRegistered(name = new ObjectName(this.newMBeanName(), "type", WroConfiguration.class.getSimpleName()))) {
                mbeanServer.registerMBean(this.wroConfiguration, name);
            }
            LOG.info("wro4j configuration: " + this.wroConfiguration);
        }
        catch (JMException e) {
            LOG.error("Exception occured while registering MBean", (Throwable)e);
        }
    }

    protected String newMBeanName() {
        String mbeanName = this.wroConfiguration.getMbeanName();
        if (StringUtils.isEmpty((CharSequence)mbeanName)) {
            String contextPath = this.getContextPath();
            mbeanName = StringUtils.isEmpty((CharSequence)contextPath) ? "ROOT" : contextPath;
            mbeanName = MBEAN_PREFIX + contextPath;
        }
        return mbeanName;
    }

    private String getContextPath() {
        String contextPath = null;
        try {
            contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)this.filterConfig.getServletContext(), new Object[0]);
        }
        catch (Exception e) {
            contextPath = "DEFAULT";
            LOG.warn("Couldn't identify contextPath because you are using older version of servlet-api (<2.5). Using " + contextPath + " contextPath.");
        }
        return contextPath.replaceFirst("/", "");
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void registerChangeListeners() {
        this.wroConfiguration.registerCacheUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.initHeaderValues();
                if (WroFilter.this.wroManagerFactory instanceof WroConfigurationChangeListener) {
                    long value = Long.valueOf(String.valueOf(event.getNewValue()));
                    ((WroConfigurationChangeListener)((Object)WroFilter.this.wroManagerFactory)).onCachePeriodChanged(value);
                }
            }
        });
        this.wroConfiguration.registerModelUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.initHeaderValues();
                if (WroFilter.this.wroManagerFactory instanceof WroConfigurationChangeListener) {
                    long value = Long.valueOf(String.valueOf(event.getNewValue()));
                    ((WroConfigurationChangeListener)((Object)WroFilter.this.wroManagerFactory)).onModelPeriodChanged(value);
                }
            }
        });
        LOG.debug("Cache & Model change listeners were registered");
    }

    private void initHeaderValues() {
        String headerParam;
        if (!this.wroConfiguration.isDebug()) {
            Long timestamp = new Date().getTime();
            Calendar cal = Calendar.getInstance();
            cal.roll(1, 1);
            this.headersMap.put(HttpHeader.CACHE_CONTROL.toString(), DEFAULT_CACHE_CONTROL_VALUE);
            this.headersMap.put(HttpHeader.LAST_MODIFIED.toString(), WroUtil.toDateAsString(timestamp));
            this.headersMap.put(HttpHeader.EXPIRES.toString(), WroUtil.toDateAsString(cal.getTimeInMillis()));
        }
        if (!StringUtils.isEmpty((CharSequence)(headerParam = this.wroConfiguration.getHeader()))) {
            try {
                if (headerParam.contains("|")) {
                    String[] headers;
                    for (String header : headers = headerParam.split("[|]")) {
                        this.parseHeader(header);
                    }
                } else {
                    this.parseHeader(headerParam);
                }
            }
            catch (Exception e) {
                throw new WroRuntimeException("Invalid header init-param value: " + headerParam + ". A correct value should have the following format: " + "<HEADER_NAME1>: <VALUE1> | <HEADER_NAME2>: <VALUE2>. " + "Ex: <look like this: " + "Expires: Thu, 15 Apr 2010 20:00:00 GMT | cache-control: public", e);
            }
        }
        LOG.debug("Header Values: {}", this.headersMap);
    }

    private void parseHeader(String header) {
        LOG.debug("parseHeader: {}", (Object)header);
        String headerName = header.substring(0, header.indexOf(":"));
        if (!this.headersMap.containsKey(headerName)) {
            this.headersMap.put(headerName, header.substring(header.indexOf(":") + 1));
        }
    }

    protected void doInit(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Context.set(Context.webContext(request, response, this.filterConfig), this.wroConfiguration);
            if (this.shouldReloadCache(request)) {
                Context.get().getConfig().reloadCache();
                WroUtil.addNoCacheHeaders(response);
                response.setStatus(200);
            } else if (this.shouldReloadModel(request)) {
                Context.get().getConfig().reloadModel();
                WroUtil.addNoCacheHeaders(response);
                response.setStatus(200);
            } else {
                this.processRequest(request, response);
                this.onRequestProcessed();
            }
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e, response, chain);
        }
        finally {
            Context.unset();
        }
    }

    protected void onRequestProcessed() {
    }

    private boolean shouldReloadModel(HttpServletRequest request) {
        return Context.get().getConfig().isDebug() && this.matchesUrl(request, API_RELOAD_MODEL);
    }

    private boolean shouldReloadCache(HttpServletRequest request) {
        return Context.get().getConfig().isDebug() && this.matchesUrl(request, API_RELOAD_CACHE);
    }

    private boolean matchesUrl(HttpServletRequest request, String apiPath) {
        Pattern pattern = Pattern.compile(".*" + apiPath + "[/]?", 2);
        Matcher m = pattern.matcher(request.getRequestURI());
        return m.matches();
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setResponseHeaders(response);
        ((WroManager)this.wroManagerFactory.create()).process();
    }

    protected void onRuntimeException(RuntimeException e, HttpServletResponse response, FilterChain chain) {
        LOG.debug("RuntimeException occured", (Throwable)e);
        try {
            LOG.debug("Cannot process. Proceeding with chain execution.");
            chain.doFilter((ServletRequest)Context.get().getRequest(), (ServletResponse)response);
        }
        catch (Exception ex) {
            LOG.error("Error while chaining the request: 404");
        }
    }

    protected void setResponseHeaders(HttpServletResponse response) {
        for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        if (this.wroConfiguration.isDebug()) {
            WroUtil.addNoCacheHeaders(response);
        }
    }

    protected WroManagerFactory getWroManagerFactory() {
        if (StringUtils.isEmpty((CharSequence)this.wroConfiguration.getWroManagerClassName())) {
            return this.newWroManagerFactory();
        }
        Class<?> factoryClass = null;
        try {
            factoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.wroConfiguration.getWroManagerClassName());
            return (WroManagerFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new WroRuntimeException("Exception while loading WroManagerFactory class", e);
        }
    }

    protected WroManagerFactory newWroManagerFactory() {
        return new BaseWroManagerFactory();
    }

    public final WroConfiguration getWroConfiguration() {
        return this.wroConfiguration;
    }

    public void destroy() {
        this.wroManagerFactory.destroy();
        this.wroConfiguration.destroy();
        Context.destroy();
    }
}

