/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.ResourceType;

public final class ReloadCacheRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadCacheRunnable.class);
    private final WeakReference<WroManager> wroManagerReference;

    public ReloadCacheRunnable(WroManager wroManager) {
        this.wroManagerReference = new WeakReference<WroManager>(wroManager);
    }

    public void run() {
        try {
            if (((WroManager)this.wroManagerReference.get()).cacheChangeCallback != null) {
                ((WroManager)this.wroManagerReference.get()).cacheChangeCallback.propertyChange(null);
            }
            WroModel model = (WroModel)((WroManager)this.wroManagerReference.get()).modelFactory.create();
            Collection<Group> groups = model.getGroups();
            for (Group group : groups) {
                for (ResourceType resourceType : ResourceType.values()) {
                    Boolean[] minimizeValues;
                    if (!group.hasResourcesOfType(resourceType)) continue;
                    HashSet<Group> groupAsList = new HashSet<Group>();
                    groupAsList.add(group);
                    Boolean[] arr$ = minimizeValues = new Boolean[]{true, false};
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        boolean minimize = arr$[i$];
                        if (Thread.interrupted()) {
                            LOG.debug("ReloadCacheRunnable was interrupted - stop processing!");
                            throw new InterruptedException();
                        }
                        String content = ((WroManager)this.wroManagerReference.get()).getGroupsProcessor().process(group, resourceType, minimize);
                        CacheEntry cacheEntry = new CacheEntry(group.getName(), resourceType, minimize);
                        ContentHashEntry contentHashEntry = ((WroManager)this.wroManagerReference.get()).getContentHashEntryByContent(content);
                        ((WroManager)this.wroManagerReference.get()).cacheStrategy.put(cacheEntry, contentHashEntry);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted exception occured: ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.error("Exception occured during cache reload: ", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Exception occured during cache reload: ", (Throwable)e);
        }
    }
}

