/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.manager.WroManager;

public final class ReloadModelRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadModelRunnable.class);
    private final WeakReference<WroManager> wroManagerReference;

    public ReloadModelRunnable(WroManager wroManager) {
        this.wroManagerReference = new WeakReference<WroManager>(wroManager);
    }

    public void run() {
        LOG.debug("Reloading Model....");
        try {
            ((WroManager)this.wroManagerReference.get()).getModelFactory().destroy();
            if (Thread.interrupted()) {
                LOG.debug("ReloadModelRunnable was interrupted - stop processing!");
                throw new InterruptedException();
            }
            ((WroManager)this.wroManagerReference.get()).getModelFactory().create();
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted exception occured: ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("Exception occured during cache reload: ", (Throwable)e);
        }
    }
}

