/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.HttpHeader;
import ro.isdc.wro.http.UnauthorizedRequestException;
import ro.isdc.wro.manager.CacheChangeCallbackAware;
import ro.isdc.wro.manager.ReloadCacheRunnable;
import ro.isdc.wro.manager.ReloadModelRunnable;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.util.HashBuilder;
import ro.isdc.wro.model.resource.util.NamingStrategy;
import ro.isdc.wro.util.DestroyableLazyInitializer;
import ro.isdc.wro.util.SchedulerHelper;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroManager
implements WroConfigurationChangeListener,
CacheChangeCallbackAware {
    private static final Logger LOG = LoggerFactory.getLogger(WroManager.class);
    WroModelFactory modelFactory;
    private GroupExtractor groupExtractor;
    private HashBuilder hashBuilder;
    CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy;
    PropertyChangeListener cacheChangeCallback;
    private final SchedulerHelper cacheSchedulerHelper = SchedulerHelper.create(new DestroyableLazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return new ReloadCacheRunnable(WroManager.this);
        }
    }, ReloadCacheRunnable.class.getSimpleName());
    private final SchedulerHelper modelSchedulerHelper = SchedulerHelper.create(new DestroyableLazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return new ReloadModelRunnable(WroManager.this);
        }
    }, ReloadModelRunnable.class.getSimpleName());
    private ProcessorsFactory processorsFactory;
    private UriLocatorFactory uriLocatorFactory;
    private NamingStrategy namingStrategy;
    @Inject
    private GroupsProcessor groupsProcessor;

    public final void process() throws IOException {
        HttpServletRequest request = Context.get().getRequest();
        HttpServletResponse response = Context.get().getResponse();
        this.validate();
        if (this.isProxyResourceRequest(request)) {
            this.serveProxyResourceRequest(request, (OutputStream)response.getOutputStream());
        } else {
            this.serveProcessedBundle(request, response);
        }
    }

    private boolean isProxyResourceRequest(HttpServletRequest request) {
        return StringUtils.contains((CharSequence)request.getRequestURI(), (CharSequence)"wroResources");
    }

    private boolean isGzipAllowed() {
        return Context.get().getConfig().isGzipEnabled() && this.isGzipSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveProcessedBundle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("serveProcessedBundle");
        ServletOutputStream os = response.getOutputStream();
        try {
            ResourceType type = this.groupExtractor.getResourceType(request);
            String groupName = this.groupExtractor.getGroupName(request);
            boolean minimize = this.groupExtractor.isMinimized(request);
            if (groupName == null || type == null) {
                throw new WroRuntimeException("No groups found for request: " + request.getRequestURI());
            }
            this.intAggregatedFolderPath(request, type);
            WroConfiguration config = Context.get().getConfig();
            this.cacheSchedulerHelper.scheduleWithPeriod(config.getCacheUpdatePeriod());
            this.modelSchedulerHelper.scheduleWithPeriod(config.getModelUpdatePeriod());
            ContentHashEntry contentHashEntry = this.getContentHashEntry(groupName, type, minimize);
            String ifNoneMatch = request.getHeader(HttpHeader.IF_NONE_MATCH.toString());
            String etagValue = String.format("\"%s\"", contentHashEntry.getHash());
            if (etagValue != null && etagValue.equals(ifNoneMatch)) {
                LOG.debug("ETag hash detected: {}. Sending {} status code", (Object)etagValue, (Object)304);
                response.setStatus(304);
                return;
            }
            if (contentHashEntry.getRawContent() != null) {
                if (this.isGzipAllowed()) {
                    response.setHeader(HttpHeader.CONTENT_ENCODING.toString(), "gzip");
                    response.setHeader("Vary", "Accept-Encoding");
                    IOUtils.write((byte[])contentHashEntry.getGzippedContent(), (OutputStream)os);
                } else {
                    IOUtils.write((String)contentHashEntry.getRawContent(), (OutputStream)os);
                }
            }
            if (type != null) {
                response.setContentType(type.getContentType() + "; charset=" + Context.get().getConfig().getEncoding());
            }
            response.setHeader(HttpHeader.ETAG.toString(), etagValue);
            stopWatch.stop();
            if (LOG.isDebugEnabled()) {
                LOG.debug("WroManager process time: {}", (Object)stopWatch.prettyPrint());
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    private void intAggregatedFolderPath(HttpServletRequest request, ResourceType type) {
        if (ResourceType.CSS == type && Context.get().getAggregatedFolderPath() == null) {
            String requestUri = request.getRequestURI();
            String cssFolder = StringUtils.removeEnd((String)requestUri, (String)FilenameUtils.getName((String)requestUri));
            String aggregatedFolder = StringUtils.removeStart((String)cssFolder, (String)request.getContextPath());
            Context.get().setAggregatedFolderPath(aggregatedFolder);
        }
    }

    public final String encodeVersionIntoGroupPath(String groupName, ResourceType resourceType, boolean minimize) {
        try {
            ContentHashEntry contentHashEntry = this.getContentHashEntry(groupName, resourceType, minimize);
            String groupUrl = this.groupExtractor.encodeGroupUrl(groupName, resourceType, minimize);
            return this.formatVersionedResource(contentHashEntry.getHash(), groupUrl);
        }
        catch (IOException e) {
            return "";
        }
    }

    protected String formatVersionedResource(String hash, String resourcePath) {
        return String.format("%s/%s", hash, resourcePath);
    }

    private ContentHashEntry getContentHashEntry(String groupName, ResourceType type, boolean minimize) throws IOException {
        CacheEntry cacheEntry = new CacheEntry(groupName, type, minimize);
        LOG.debug("Searching cache entry: {}", (Object)cacheEntry);
        ContentHashEntry contentHashEntry = this.cacheStrategy.get(cacheEntry);
        if (contentHashEntry == null) {
            LOG.debug("Cache is empty. Perform processing...");
            WroModel model = (WroModel)this.modelFactory.create();
            if (model == null) {
                throw new WroRuntimeException("Cannot build a valid wro model");
            }
            Group group = model.getGroupByName(groupName);
            String content = this.groupsProcessor.process(group, type, minimize);
            contentHashEntry = this.getContentHashEntryByContent(content);
            if (!Context.get().getConfig().isDisableCache()) {
                this.cacheStrategy.put(cacheEntry, contentHashEntry);
            }
        }
        return contentHashEntry;
    }

    ContentHashEntry getContentHashEntryByContent(String content) throws IOException {
        String hash = null;
        if (content != null) {
            LOG.debug("Content to fingerprint: [{}]", (Object)StringUtils.abbreviate((String)content, (int)40));
            hash = this.hashBuilder.getHash(new ByteArrayInputStream(content.getBytes()));
        }
        ContentHashEntry entry = ContentHashEntry.valueOf(content, hash);
        LOG.debug("computed entry: {}", (Object)entry);
        return entry;
    }

    private void serveProxyResourceRequest(HttpServletRequest request, OutputStream outputStream) throws IOException {
        String resourceId = request.getParameter("id");
        LOG.debug("locating stream for resourceId: {}", (Object)resourceId);
        CssUrlRewritingProcessor processor = ProcessorsUtils.findPreProcessorByClass(CssUrlRewritingProcessor.class, this.processorsFactory.getPreProcessors());
        if (processor != null && !processor.isUriAllowed(resourceId)) {
            throw new UnauthorizedRequestException("Unauthorized resource request detected! " + request.getRequestURI());
        }
        InputStream is = this.uriLocatorFactory.locate(resourceId);
        if (is == null) {
            throw new WroRuntimeException("Cannot process request with uri: " + request.getRequestURI());
        }
        IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    @Override
    public final void onCachePeriodChanged(long period) {
        LOG.info("onCachePeriodChanged with value {} has been triggered!", (Object)period);
        this.cacheSchedulerHelper.scheduleWithPeriod(period);
        this.cacheStrategy.clear();
    }

    @Override
    public final void onModelPeriodChanged(long period) {
        LOG.info("onModelPeriodChanged with value {} has been triggered!", (Object)period);
        this.getModelFactory().destroy();
        this.modelSchedulerHelper.scheduleWithPeriod(period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            this.cacheSchedulerHelper.destroy();
            this.modelSchedulerHelper.destroy();
            this.cacheStrategy.destroy();
            this.modelFactory.destroy();
        }
        catch (Exception e) {
            LOG.error("Exception occured during manager destroy!!!");
        }
        finally {
            LOG.info("WroManager destroyed");
        }
    }

    private void validate() {
        Validate.notNull(this.cacheStrategy, (String)"cacheStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.groupsProcessor, (String)"groupsProcessor was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.uriLocatorFactory, (String)"uriLocatorFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.processorsFactory, (String)"processorsFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.groupExtractor, (String)"GroupExtractor was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.modelFactory, (String)"ModelFactory was not set!", (Object[])new Object[0]);
        Validate.notNull(this.cacheStrategy, (String)"cacheStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.hashBuilder, (String)"HashBuilder was not set!", (Object[])new Object[0]);
    }

    @Override
    public final void registerCallback(PropertyChangeListener callback) {
        this.cacheChangeCallback = callback;
    }

    private boolean isGzipSupported() {
        return WroUtil.isGzipSupported(Context.get().getRequest());
    }

    public final WroManager setGroupExtractor(GroupExtractor groupExtractor) {
        Validate.notNull((Object)groupExtractor);
        this.groupExtractor = groupExtractor;
        return this;
    }

    public final WroManager setModelFactory(WroModelFactory modelFactory) {
        Validate.notNull((Object)modelFactory);
        this.modelFactory = modelFactory;
        return this;
    }

    public final WroManager setCacheStrategy(CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy) {
        Validate.notNull(cacheStrategy);
        this.cacheStrategy = cacheStrategy;
        return this;
    }

    public WroManager setHashBuilder(HashBuilder contentDigester) {
        Validate.notNull((Object)contentDigester);
        this.hashBuilder = contentDigester;
        return this;
    }

    public WroModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public ProcessorsFactory getProcessorsFactory() {
        return this.processorsFactory;
    }

    public WroManager setProcessorsFactory(ProcessorsFactory processorsFactory) {
        this.processorsFactory = processorsFactory;
        return this;
    }

    public WroManager setUriLocatorFactory(UriLocatorFactory uriLocatorFactory) {
        this.uriLocatorFactory = uriLocatorFactory;
        return this;
    }

    public CacheStrategy<CacheEntry, ContentHashEntry> getCacheStrategy() {
        return this.cacheStrategy;
    }

    public UriLocatorFactory getUriLocatorFactory() {
        return this.uriLocatorFactory;
    }

    public final NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    GroupsProcessor getGroupsProcessor() {
        return this.groupsProcessor;
    }

    public final WroManager setNamingStrategy(NamingStrategy namingStrategy) {
        Validate.notNull((Object)namingStrategy);
        this.namingStrategy = namingStrategy;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

