/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.manager.CacheChangeCallbackAware;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.WroManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.FallbackAwareWroModelFactory;
import ro.isdc.wro.model.factory.InMemoryCacheableWroModelFactory;
import ro.isdc.wro.model.factory.ModelTransformerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.DefaultGroupExtractor;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.factory.DefaultProcesorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.util.HashBuilder;
import ro.isdc.wro.model.resource.util.NamingStrategy;
import ro.isdc.wro.model.resource.util.NoOpNamingStrategy;
import ro.isdc.wro.model.resource.util.SHA1HashBuilder;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.DestroyableLazyInitializer;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWroManagerFactory
implements WroManagerFactory,
WroConfigurationChangeListener,
CacheChangeCallbackAware,
ObjectFactory<WroManager> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseWroManagerFactory.class);
    private PropertyChangeListener cacheChangeCallback;
    private GroupExtractor groupExtractor;
    private WroModelFactory modelFactory;
    private CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy;
    private HashBuilder hashBuilder;
    private List<Transformer<WroModel>> modelTransformers;
    private UriLocatorFactory uriLocatorFactory;
    private ProcessorsFactory processorsFactory;
    private NamingStrategy namingStrategy;
    private DestroyableLazyInitializer<WroManager> managerInitializer = new DestroyableLazyInitializer<WroManager>(){

        @Override
        protected WroManager initialize() {
            WroManager manager = new WroManager();
            if (BaseWroManagerFactory.this.modelFactory == null) {
                BaseWroManagerFactory.this.modelFactory = BaseWroManagerFactory.this.newModelFactory();
            }
            if (BaseWroManagerFactory.this.groupExtractor == null) {
                BaseWroManagerFactory.this.groupExtractor = BaseWroManagerFactory.this.newGroupExtractor();
            }
            if (BaseWroManagerFactory.this.cacheStrategy == null) {
                BaseWroManagerFactory.this.cacheStrategy = BaseWroManagerFactory.this.newCacheStrategy();
            }
            if (BaseWroManagerFactory.this.hashBuilder == null) {
                BaseWroManagerFactory.this.hashBuilder = BaseWroManagerFactory.this.newHashBuilder();
            }
            if (BaseWroManagerFactory.this.modelTransformers == null) {
                BaseWroManagerFactory.this.modelTransformers = BaseWroManagerFactory.this.newModelTransformers();
            }
            if (BaseWroManagerFactory.this.processorsFactory == null) {
                BaseWroManagerFactory.this.processorsFactory = BaseWroManagerFactory.this.newProcessorsFactory();
            }
            if (BaseWroManagerFactory.this.uriLocatorFactory == null) {
                BaseWroManagerFactory.this.uriLocatorFactory = BaseWroManagerFactory.this.newUriLocatorFactory();
            }
            if (BaseWroManagerFactory.this.namingStrategy == null) {
                BaseWroManagerFactory.this.namingStrategy = new NoOpNamingStrategy();
            }
            manager.setGroupExtractor(BaseWroManagerFactory.this.groupExtractor);
            manager.setCacheStrategy(BaseWroManagerFactory.this.cacheStrategy);
            manager.setHashBuilder(BaseWroManagerFactory.this.hashBuilder);
            manager.registerCallback(BaseWroManagerFactory.this.cacheChangeCallback);
            manager.setUriLocatorFactory(BaseWroManagerFactory.this.uriLocatorFactory);
            manager.setProcessorsFactory(BaseWroManagerFactory.this.processorsFactory);
            manager.setNamingStrategy(BaseWroManagerFactory.this.namingStrategy);
            manager.setModelFactory(new ModelTransformerFactory(new InMemoryCacheableWroModelFactory(new FallbackAwareWroModelFactory(BaseWroManagerFactory.this.modelFactory))).setTransformers(BaseWroManagerFactory.this.modelTransformers));
            Injector injector = new Injector(manager);
            injector.inject(BaseWroManagerFactory.this.modelFactory);
            for (Transformer transformer : BaseWroManagerFactory.this.modelTransformers) {
                injector.inject(transformer);
            }
            return manager;
        }
    };

    @Override
    public final WroManager create() {
        return this.managerInitializer.get();
    }

    public BaseWroManagerFactory setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    protected List<Transformer<WroModel>> newModelTransformers() {
        this.addModelTransformer(new WildcardExpanderModelTransformer());
        return this.modelTransformers;
    }

    protected ProcessorsFactory newProcessorsFactory() {
        return new DefaultProcesorsFactory();
    }

    protected UriLocatorFactory newUriLocatorFactory() {
        return new DefaultUriLocatorFactory();
    }

    protected HashBuilder newHashBuilder() {
        return new SHA1HashBuilder();
    }

    @Override
    public void registerCallback(PropertyChangeListener callback) {
        this.cacheChangeCallback = callback;
    }

    @Override
    public void onCachePeriodChanged(long period) {
        this.managerInitializer.get().onCachePeriodChanged(period);
    }

    @Override
    public void onModelPeriodChanged(long period) {
        this.managerInitializer.get().onModelPeriodChanged(period);
        this.managerInitializer.get().getCacheStrategy().clear();
    }

    protected CacheStrategy<CacheEntry, ContentHashEntry> newCacheStrategy() {
        return new LruMemoryCacheStrategy<CacheEntry, ContentHashEntry>();
    }

    protected GroupExtractor newGroupExtractor() {
        return new DefaultGroupExtractor();
    }

    protected WroModelFactory newModelFactory() {
        try {
            LOG.info("Trying to use SmartWroModelFactory as default model factory");
            Class<WroModelFactory> smartFactoryClass = Class.forName("ro.isdc.wro.extensions.model.factory.SmartWroModelFactory").asSubclass(WroModelFactory.class);
            return smartFactoryClass.newInstance();
        }
        catch (Exception e) {
            LOG.info("[FAIL] SmartWroModelFactory is not available. Using default model factory.");
            LOG.debug("Reason: {}", (Object)e.toString());
            return new XmlModelFactory();
        }
    }

    public BaseWroManagerFactory setGroupExtractor(GroupExtractor groupExtractor) {
        this.groupExtractor = groupExtractor;
        return this;
    }

    public BaseWroManagerFactory setModelFactory(WroModelFactory modelFactory) {
        this.modelFactory = modelFactory;
        return this;
    }

    public BaseWroManagerFactory setHashBuilder(HashBuilder hashBuilder) {
        this.hashBuilder = hashBuilder;
        return this;
    }

    public BaseWroManagerFactory setModelTransformers(List<Transformer<WroModel>> modelTransformers) {
        this.modelTransformers = modelTransformers;
        return this;
    }

    public BaseWroManagerFactory addModelTransformer(Transformer<WroModel> modelTransformer) {
        if (this.modelTransformers == null) {
            this.modelTransformers = new ArrayList<Transformer<WroModel>>();
        }
        this.modelTransformers.add(modelTransformer);
        return this;
    }

    public BaseWroManagerFactory setCacheStrategy(CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
        return this;
    }

    public BaseWroManagerFactory setUriLocatorFactory(UriLocatorFactory uriLocatorFactory) {
        this.uriLocatorFactory = uriLocatorFactory;
        return this;
    }

    public void setProcessorsFactory(ProcessorsFactory processorsFactory) {
        this.processorsFactory = processorsFactory;
    }

    @Override
    public void destroy() {
        this.managerInitializer.destroy();
    }
}

