/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertiesAndFilterConfigWroConfigurationFactory;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.SimpleUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ConfigurableProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableWroManagerFactory
extends BaseWroManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableWroManagerFactory.class);
    private Properties configProperties;
    public static final String PARAM_URI_LOCATORS = "uriLocators";

    private Map<String, UriLocator> createLocatorsMap() {
        HashMap<String, UriLocator> map = new HashMap<String, UriLocator>();
        map.put("servletContext", new ServletContextUriLocator());
        map.put("classpath", new ClasspathUriLocator());
        map.put("url", new UrlUriLocator());
        return map;
    }

    protected void contributeLocators(Map<String, UriLocator> map) {
    }

    protected void contributePreProcessors(Map<String, ResourcePreProcessor> map) {
    }

    protected void contributePostProcessors(Map<String, ResourcePostProcessor> map) {
    }

    @Override
    protected UriLocatorFactory newUriLocatorFactory() {
        SimpleUriLocatorFactory factory = new SimpleUriLocatorFactory();
        Map<String, UriLocator> map = this.createLocatorsMap();
        this.contributeLocators(map);
        String uriLocators = Context.get().getFilterConfig().getInitParameter(PARAM_URI_LOCATORS);
        List<UriLocator> locators = ConfigurableProcessorsFactory.getListOfItems(uriLocators, map);
        for (UriLocator locator : locators) {
            factory.addUriLocator(locator);
        }
        if (factory.getUriLocators().isEmpty()) {
            return new DefaultUriLocatorFactory();
        }
        return factory;
    }

    @Override
    protected ProcessorsFactory newProcessorsFactory() {
        ConfigurableProcessorsFactory factory = new ConfigurableProcessorsFactory(){

            @Override
            public Map<String, ResourcePreProcessor> newPreProcessorsMap() {
                Map<String, ResourcePreProcessor> map = ProcessorsUtils.createPreProcessorsMap();
                ConfigurableWroManagerFactory.this.contributePreProcessors(map);
                return map;
            }

            @Override
            public Map<String, ResourcePostProcessor> newPostProcessorsMap() {
                Map<String, ResourcePostProcessor> map = ProcessorsUtils.createPostProcessorsMap();
                ConfigurableWroManagerFactory.this.contributePostProcessors(map);
                return map;
            }

            @Override
            protected Properties newProperties() {
                Properties props = new Properties();
                this.updatePropertiesWithProcessors(props, "preProcessors");
                this.updatePropertiesWithProcessors(props, "postProcessors");
                return props;
            }

            private void updatePropertiesWithProcessors(Properties props, String paramName) {
                FilterConfig filterConfig = Context.get().getFilterConfig();
                String processorsAsString = filterConfig.getInitParameter(paramName);
                if (processorsAsString != null) {
                    props.setProperty(paramName, processorsAsString);
                } else {
                    String value = ConfigurableWroManagerFactory.this.getConfigProperties().getProperty(paramName);
                    if (value != null) {
                        props.setProperty(paramName, value);
                    }
                }
            }
        };
        return factory;
    }

    protected Properties newConfigProperties() {
        Properties props = new Properties();
        try {
            props.load(PropertiesAndFilterConfigWroConfigurationFactory.defaultConfigPropertyStream(Context.get().getFilterConfig()));
        }
        catch (Exception e) {
            LOG.debug("No configuration property file found.");
        }
        return props;
    }

    private Properties getConfigProperties() {
        if (this.configProperties == null) {
            this.configProperties = this.newConfigProperties();
        }
        return this.configProperties;
    }

    public ConfigurableWroManagerFactory setConfigProperties(Properties configProperties) {
        Validate.notNull((Object)configProperties);
        this.configProperties = configProperties;
        return this;
    }
}

