/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.WroModelFactoryDecorator;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTransformerFactory
extends WroModelFactoryDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ModelTransformerFactory.class);
    private List<? extends Transformer<WroModel>> modelTransformers = Collections.emptyList();

    public ModelTransformerFactory(WroModelFactory decorated) {
        super(decorated);
    }

    public ModelTransformerFactory setTransformers(List<? extends Transformer<WroModel>> modelTransformers) {
        Validate.notNull(modelTransformers);
        this.modelTransformers = modelTransformers;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WroModel create() {
        WroModel model = super.create();
        LOG.debug("using {} transformers", this.modelTransformers);
        for (Transformer<WroModel> transformer : this.modelTransformers) {
            LOG.debug("using transformer: {}", transformer.getClass());
            ModelTransformerFactory modelTransformerFactory = this;
            synchronized (modelTransformerFactory) {
                try {
                    model = transformer.transform(model);
                }
                catch (Exception e) {
                    throw new WroRuntimeException("Exception during model transformation", e);
                }
            }
        }
        return model;
    }
}

