/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.RecursiveGroupDefinitionException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(XmlModelFactory.class);
    private static final String DEFAULT_FILE_NAME = "wro.xml";
    private static final String XML_SCHEMA_FILE = "ro/isdc/wro/wro.xsd";
    private static final String TAG_GROUP = "group";
    private static final String TAG_IMPORT = "import";
    private static final String TAG_CSS = "css";
    private static final String TAG_JS = "js";
    private static final String TAG_GROUP_REF = "group-ref";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String ATTR_MINIMIZE = "minimize";
    final Map<String, Element> allGroupElements = new HashMap<String, Element>();
    final Collection<String> processingGroups = new HashSet<String>();
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    private final Set<String> processedImports = new HashSet<String>();

    @Override
    public WroModel create() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            InputStream configResource = this.getModelResourceAsStream();
            if (configResource == null) {
                throw new WroRuntimeException("Could not locate config resource (wro.xml)!");
            }
            document = factory.newDocumentBuilder().parse(configResource);
            this.validate(document);
            document.getDocumentElement().normalize();
        }
        catch (IOException e) {
            throw new WroRuntimeException("Cannot find XML to parse", e);
        }
        catch (SAXException e) {
            throw new WroRuntimeException("The wro configuration file contains errors: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new WroRuntimeException("Parsing error", e);
        }
        this.processGroups(document);
        WroModel model = this.createModel();
        this.processImports(document, model);
        this.processedImports.clear();
        return model;
    }

    private Schema getSchema() throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream schemaStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(XML_SCHEMA_FILE);
        StreamSource schemaFile = new StreamSource(schemaStream);
        Schema schema = factory.newSchema(schemaFile);
        return schema;
    }

    private void processGroups(Document document) {
        NodeList groupNodeList = document.getElementsByTagName(TAG_GROUP);
        for (int i = 0; i < groupNodeList.getLength(); ++i) {
            Element groupElement = (Element)groupNodeList.item(i);
            String name = groupElement.getAttribute(ATTR_GROUP_NAME);
            this.allGroupElements.put(name, groupElement);
        }
    }

    private void processImports(Document document, WroModel model) {
        NodeList importsList = document.getElementsByTagName(TAG_IMPORT);
        LOG.debug("number of imports: {}", (Object)importsList.getLength());
        for (int i = 0; i < importsList.getLength(); ++i) {
            Element element = (Element)importsList.item(i);
            final String name = element.getTextContent();
            LOG.debug("processing import: {}", (Object)name);
            LOG.debug("processImports#uriLocatorFactory: {}", (Object)this.uriLocatorFactory);
            XmlModelFactory importedModelFactory = new XmlModelFactory(){

                protected InputStream getModelResourceAsStream() throws IOException {
                    LOG.debug("build model from import: {}", (Object)name);
                    LOG.debug("uriLocatorFactory: {}", (Object)XmlModelFactory.this.uriLocatorFactory);
                    return XmlModelFactory.this.uriLocatorFactory.locate(name);
                }
            };
            importedModelFactory.uriLocatorFactory = this.uriLocatorFactory;
            if (this.processedImports.contains(name)) {
                String message = "Recursive import detected: " + name;
                LOG.error(message);
                throw new RecursiveGroupDefinitionException(message);
            }
            this.processedImports.add(name);
            importedModelFactory.processedImports.addAll(this.processedImports);
            model.merge(importedModelFactory.create());
        }
    }

    private WroModel createModel() {
        WroModel model = new WroModel();
        HashSet<Group> groups = new HashSet<Group>();
        for (Element element : this.allGroupElements.values()) {
            this.parseGroup(element, groups);
        }
        model.setGroups(groups);
        return model;
    }

    private Collection<Resource> parseGroup(Element element, Collection<Group> groups) {
        String name = element.getAttribute(ATTR_GROUP_NAME);
        if (this.processingGroups.contains(name)) {
            throw new RecursiveGroupDefinitionException("Infinite Recursion detected for the group: " + name + ". Recursion path: " + this.processingGroups);
        }
        this.processingGroups.add(name);
        LOG.debug("\tgroupName={}", (Object)name);
        Group parsedGroup = this.getGroupByName(name, groups);
        if (parsedGroup != null) {
            this.processingGroups.remove(name);
            return parsedGroup.getResources();
        }
        Group group = new Group(name);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        NodeList resourceNodeList = element.getChildNodes();
        for (int i = 0; i < resourceNodeList.getLength(); ++i) {
            Node node = resourceNodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element resourceElement = (Element)node;
            this.parseResource(resourceElement, resources, groups);
        }
        group.setResources(resources);
        this.processingGroups.remove(name);
        groups.add(group);
        return resources;
    }

    private Group getGroupByName(String name, Collection<Group> groups) {
        for (Group group : groups) {
            if (!name.equals(group.getName())) continue;
            return group;
        }
        return null;
    }

    private void parseResource(Element resourceElement, Collection<Resource> resources, Collection<Group> groups) {
        ResourceType type = null;
        String tagName = resourceElement.getTagName();
        String uri = resourceElement.getTextContent();
        if (TAG_JS.equals(tagName)) {
            type = ResourceType.JS;
        } else if (TAG_CSS.equals(tagName)) {
            type = ResourceType.CSS;
        } else if (TAG_GROUP_REF.equals(tagName)) {
            Element groupElement = this.allGroupElements.get(uri);
            resources.addAll(this.parseGroup(groupElement, groups));
        } else {
            throw new WroRuntimeException("Usupported resource type: " + tagName);
        }
        if (type != null) {
            String minimizeAsString = resourceElement.getAttribute(ATTR_MINIMIZE);
            boolean minimize = StringUtils.isEmpty((CharSequence)minimizeAsString) ? true : Boolean.valueOf(resourceElement.getAttribute(ATTR_MINIMIZE));
            Resource resource = Resource.create(uri, type);
            resource.setMinimize(minimize);
            resources.add(resource);
        }
    }

    private void validate(Document document) throws IOException, SAXException {
        Schema schema = this.getSchema();
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    @Override
    protected String getDefaultModelFilename() {
        return DEFAULT_FILE_NAME;
    }
}

