/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Group {
    private static final Logger LOG = LoggerFactory.getLogger(Group.class);
    private String name;
    private final List<Resource> resources = new ArrayList<Resource>();

    public Group() {
    }

    public Group(String name) {
        Validate.notNull((Object)name, (String)"Group name cannot be null.", (Object[])new Object[0]);
        this.name = name;
    }

    public final boolean hasResourcesOfType(ResourceType resourceType) {
        Validate.notNull((Object)((Object)resourceType), (String)"ResourceType cannot be null!", (Object[])new Object[0]);
        for (Resource resource : this.resources) {
            if (!resourceType.equals((Object)resource.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean hasResource(Resource resourceToCheck) {
        for (Resource resource : this.resources) {
            if (!resource.equals(resourceToCheck)) continue;
            return true;
        }
        return false;
    }

    public void replace(Resource resource, List<Resource> expandedResources) {
        LOG.debug("replacing resource {} with expanded resources: {}", (Object)resource, expandedResources);
        Validate.notNull((Object)resource);
        Validate.notNull(expandedResources);
        boolean found = false;
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resourceItem : this.resources) {
            if (resourceItem.equals(resource)) {
                found = true;
                for (Resource expandedResource : expandedResources) {
                    expandedResource.setMinimize(resource.isMinimize());
                    if (this.hasResource(expandedResource)) continue;
                    result.add(expandedResource);
                }
                continue;
            }
            result.add(resourceItem);
        }
        if (!found) {
            throw new IllegalArgumentException("Cannot replace resource: " + resource + " for group: " + this + " because the resource is not a part of this group.");
        }
        this.setResources(result);
    }

    public String getName() {
        return this.name;
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(new ArrayList<Resource>(this.resources));
    }

    public Group addResource(Resource resource) {
        Validate.notNull((Object)resource);
        if (!this.hasResource(resource)) {
            this.resources.add(resource);
        } else {
            LOG.warn("Resource {} is already contained in this group, skiping it.", (Object)resource);
        }
        return this;
    }

    public final void setResources(List<Resource> resources) {
        Validate.notNull(resources);
        this.resources.clear();
        for (Resource resource : resources) {
            this.addResource(resource);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group group = (Group)obj;
            return this.getName().equals(group.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

