/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsProcessor.class);
    @Inject
    private ProcessorsFactory processorsFactory;
    @Inject
    private transient PreProcessorExecutor preProcessorExecutor;

    public String process(Group group, ResourceType type, boolean minimize) {
        Validate.notNull((Object)group);
        Validate.notNull((Object)((Object)type));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("filter resources");
        List<Resource> filteredResources = this.getFilteredResources(group, type);
        try {
            stopWatch.stop();
            stopWatch.start("pre process and merge");
            String result = this.preProcessorExecutor.processAndMerge(filteredResources, minimize);
            stopWatch.stop();
            stopWatch.start("post process");
            String postProcessedResult = this.applyPostProcessors(type, result, minimize);
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
            return postProcessedResult;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while merging resources", e);
        }
    }

    private String applyPostProcessors(ResourceType resourceType, String content, boolean minimize) throws IOException {
        Validate.notNull((Object)content);
        Collection<ResourcePostProcessor> allPostProcessors = this.processorsFactory.getPostProcessors();
        if (allPostProcessors.isEmpty() && this.processorsFactory.getPreProcessors().isEmpty()) {
            LOG.warn("No processors defined. Please, check if your configuration is correct.");
        }
        Collection<ResourcePostProcessor> processors = ProcessorsUtils.getProcessorsByType(resourceType, allPostProcessors);
        processors.addAll(ProcessorsUtils.getProcessorsByType(null, allPostProcessors));
        if (!minimize) {
            processors = ProcessorsUtils.getMinimizeFreeProcessors(processors);
        }
        LOG.debug("postProcessors: {}", processors);
        String output = this.applyPostProcessors(processors, content);
        return output;
    }

    private String applyPostProcessors(Collection<ResourcePostProcessor> processors, String content) throws IOException {
        if (processors.isEmpty()) {
            return content;
        }
        StringReader input = new StringReader(content.toString());
        Object output = null;
        StopWatch stopWatch = new StopWatch();
        for (ResourcePostProcessor processor : processors) {
            stopWatch.start("Using " + processor.getClass().getSimpleName());
            output = new StringWriter();
            processor.process(input, (Writer)output);
            input = new StringReader(output.toString());
            stopWatch.stop();
        }
        LOG.debug(stopWatch.prettyPrint());
        return output.toString();
    }

    private final List<Resource> getFilteredResources(Group group, ResourceType type) {
        ArrayList<Resource> filteredResources = new ArrayList<Resource>();
        for (Resource resource : group.getResources()) {
            if (type != resource.getType()) continue;
            if (filteredResources.contains(resource)) {
                LOG.warn("Duplicated resource detected: " + resource + ". This resource won't be included more than once!");
                continue;
            }
            filteredResources.add(resource);
        }
        return filteredResources;
    }
}

