/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.InjectorProcessorsFactoryDecorator;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.locator.factory.InjectorUriLocatorFactoryDecorator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.util.NamingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Injector {
    private static final Logger LOG = LoggerFactory.getLogger(Injector.class);
    private final WroManager wroManager;
    private final UriLocatorFactory uriLocatorFactory;
    private PreProcessorExecutor preProcessorExecutor;
    private final ProcessorsFactory processorsFactory;
    private final GroupsProcessor groupsProcessor;

    public Injector(WroManager wroManager) {
        Validate.notNull((Object)wroManager);
        this.wroManager = wroManager;
        this.groupsProcessor = new GroupsProcessor();
        this.uriLocatorFactory = new InjectorUriLocatorFactoryDecorator(wroManager.getUriLocatorFactory(), this);
        wroManager.setUriLocatorFactory(this.uriLocatorFactory);
        this.processorsFactory = new InjectorProcessorsFactoryDecorator(wroManager.getProcessorsFactory(), this);
        wroManager.setProcessorsFactory(this.processorsFactory);
        this.inject(wroManager);
    }

    private PreProcessorExecutor getPreProcessorExecutor() {
        if (this.preProcessorExecutor == null) {
            this.preProcessorExecutor = new PreProcessorExecutor();
            this.inject(this.preProcessorExecutor);
        }
        return this.preProcessorExecutor;
    }

    public void inject(Object object) {
        Validate.notNull((Object)object);
        this.processInjectAnnotation(object);
    }

    private void processInjectAnnotation(Object processor) {
        LOG.debug("processInjectAnnotation for: {}", (Object)processor.getClass().getSimpleName());
        try {
            Collection<Field> fields = this.getAllFields(processor);
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Inject.class) || this.acceptAnnotatedField(processor, field)) continue;
                throw new WroRuntimeException("@Inject cannot be applied field of type: " + field.getType());
            }
        }
        catch (Exception e) {
            LOG.error("Error while scanning @Inject annotation", (Throwable)e);
            throw new WroRuntimeException("Exception while trying to process @Inject annotation", e);
        }
    }

    private Collection<Field> getAllFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(object.getClass().getDeclaredFields()));
        Class<?> superClass = object.getClass().getSuperclass();
        do {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        } while ((superClass = superClass.getSuperclass()) != null);
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acceptAnnotatedField(Object object, Field field) throws IllegalAccessException {
        boolean accept = false;
        try {
            field.setAccessible(true);
            if (UriLocatorFactory.class.isAssignableFrom(field.getType())) {
                field.set(object, this.uriLocatorFactory);
                accept = true;
                boolean bl = true;
                return bl;
            }
            if (ProcessorsFactory.class.isAssignableFrom(field.getType())) {
                field.set(object, this.processorsFactory);
                accept = true;
                boolean bl = true;
                return bl;
            }
            if (PreProcessorExecutor.class.isAssignableFrom(field.getType())) {
                field.set(object, this.getPreProcessorExecutor());
                accept = true;
                boolean bl = true;
                return bl;
            }
            if (NamingStrategy.class.isAssignableFrom(field.getType())) {
                field.set(object, this.wroManager.getNamingStrategy());
                accept = true;
                boolean bl = true;
                return bl;
            }
            if (GroupsProcessor.class.isAssignableFrom(field.getType())) {
                field.set(object, this.groupsProcessor);
                this.inject(this.groupsProcessor);
                accept = true;
                boolean bl = true;
                return bl;
            }
            if (Injector.class.isAssignableFrom(field.getType())) {
                field.set(object, this);
                accept = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = accept;
            return bl;
        }
        finally {
            if (accept) {
                LOG.debug("\t[OK] Injected field of type: {}", (Object)field.getType().getSimpleName());
            }
        }
    }
}

