/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.ProcessorsFactoryDecorator;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorProcessorsFactoryDecorator
extends ProcessorsFactoryDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorProcessorsFactoryDecorator.class);
    private final Injector injector;

    public InjectorProcessorsFactoryDecorator(ProcessorsFactory decorated, Injector injector) {
        super(decorated);
        Validate.notNull((Object)injector);
        this.injector = injector;
    }

    @Override
    public Collection<ResourcePreProcessor> getPreProcessors() {
        this.scanPreProcessors();
        return super.getPreProcessors();
    }

    private void scanPreProcessors() {
        LOG.debug("scanPreProcessors");
        for (ResourcePreProcessor processor : super.getPreProcessors()) {
            this.injector.inject(processor);
        }
    }

    @Override
    public Collection<ResourcePostProcessor> getPostProcessors() {
        this.scanPostProcessors();
        return super.getPostProcessors();
    }

    private void scanPostProcessors() {
        LOG.debug("scanPostProcessors");
        StopWatch watch = new StopWatch();
        watch.start("scan post processors");
        for (ResourcePostProcessor processor : super.getPostProcessors()) {
            this.injector.inject(processor);
        }
        watch.stop();
        LOG.debug(watch.prettyPrint());
    }
}

