/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreProcessorExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PreProcessorExecutor.class);
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private ProcessorsFactory processorsFactory;
    private ExecutorService executor;

    public String processAndMerge(final List<Resource> resources, final boolean minimize) throws IOException {
        Validate.notNull(resources);
        StringBuffer result = new StringBuffer();
        boolean isParallel = Context.get().getConfig().isParallelPreprocessing();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (isParallel && resources.size() > 1 && availableProcessors > 1) {
            ArrayList<1> callables = new ArrayList<1>();
            for (final Resource resource : resources) {
                callables.add(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return PreProcessorExecutor.this.processSingleResource(resource, resources, minimize);
                    }
                });
            }
            ExecutorService exec = this.getExecutorService();
            ArrayList futures = new ArrayList();
            for (Callable callable : callables) {
                futures.add(exec.submit(callable));
            }
            for (Future future : futures) {
                try {
                    result.append((String)future.get());
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof WroRuntimeException) {
                        throw (WroRuntimeException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new WroRuntimeException("", e.getCause());
                }
            }
        } else {
            for (Resource resource : resources) {
                LOG.debug("\tmerging resource: {}", (Object)resource);
                result.append(this.processSingleResource(resource, resources, minimize));
            }
        }
        return result.toString();
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            int threadPoolSize = Runtime.getRuntime().availableProcessors();
            this.executor = Executors.newFixedThreadPool(threadPoolSize, WroUtil.createDaemonThreadFactory("parallelPreprocessing"));
        }
        return this.executor;
    }

    private String processSingleResource(Resource resource, List<Resource> resources, boolean minimize) throws IOException {
        LOG.debug("processingSingleResource: {}", (Object)resource);
        Collection<ResourcePreProcessor> processors = ProcessorsUtils.getProcessorsByType(resource.getType(), this.processorsFactory.getPreProcessors());
        if (!minimize) {
            processors = ProcessorsUtils.getMinimizeFreeProcessors(processors);
        }
        return this.applyPreProcessors(resource, resources, processors);
    }

    /*
     * Unable to fully structure code
     */
    private String applyPreProcessors(Resource resource, List<Resource> resources, Collection<ResourcePreProcessor> processors) throws IOException {
        PreProcessorExecutor.LOG.debug("applying preProcessors: {}", processors);
        resourceContent = this.getResourceContent(resource, resources);
        if (processors.isEmpty()) {
            return resourceContent;
        }
        writer = null;
        stopWatch = new StopWatch();
        for (ResourcePreProcessor processor : processors) {
            stopWatch.start("Using " + processor.getClass().getSimpleName());
            writer = new StringWriter();
            v0 = applyProcessor = resource.isMinimize() != false || processor.getClass().isAnnotationPresent(Minimize.class) == false;
            if (applyProcessor) {
                PreProcessorExecutor.LOG.debug("\tPreProcessing - {}", (Object)processor.getClass().getSimpleName());
                reader = new StringReader(resourceContent);
                try {
                    processor.process(resource, reader, (Writer)writer);
                }
                catch (IOException e) {
                    if (Context.get().getConfig().isIgnoreMissingResources()) ** GOTO lbl22
                    throw e;
                }
            } else {
                writer.write(resourceContent);
                PreProcessorExecutor.LOG.debug("skipped processing on resource: {}", (Object)resource);
            }
lbl22:
            // 3 sources

            resourceContent = writer.toString();
            stopWatch.stop();
        }
        PreProcessorExecutor.LOG.debug(stopWatch.prettyPrint());
        return writer.toString();
    }

    private String getResourceContent(Resource resource, List<Resource> resources) throws IOException {
        WroConfiguration config = Context.get().getConfig();
        try {
            BOMInputStream is = new BOMInputStream(this.uriLocatorFactory.locate(resource.getUri()));
            String result = IOUtils.toString((InputStream)is, (String)config.getEncoding());
            is.close();
            return result;
        }
        catch (IOException e) {
            LOG.warn("Invalid resource found: " + resource);
            if (config.isIgnoreMissingResources()) {
                return "";
            }
            LOG.error("Cannot ignore the missing resource:  " + resource);
            throw e;
        }
    }
}

