/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ro.isdc.wro.model.resource.ResourceType;

public class Resource {
    private ResourceType type;
    private String uri;
    private boolean minimize = true;

    public Resource() {
    }

    private Resource(String uri, ResourceType type) {
        Validate.notNull((Object)uri, (String)"URI cannot be null!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)type), (String)"ResourceType cannot be null!", (Object[])new Object[0]);
        this.uri = Resource.cleanUri(uri);
        this.type = type;
    }

    public static Resource create(String uri, ResourceType type) {
        return new Resource(uri, type);
    }

    private static String cleanUri(String uri) {
        String result = uri.trim();
        if (!StringUtils.isEmpty((CharSequence)uri)) {
            int endIndex = result.length() - 1;
            if (result.lastIndexOf(47) == endIndex) {
                result = result.substring(0, endIndex);
            }
        }
        return result;
    }

    public void setType(ResourceType type) {
        Validate.notNull((Object)((Object)type), (String)"ResourceType cannot be null!", (Object[])new Object[0]);
        this.type = type;
    }

    public void setUri(String uri) {
        Validate.notNull((Object)uri, (String)"Uri cannot be null!", (Object[])new Object[0]);
        this.uri = Resource.cleanUri(uri);
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Resource) {
            Resource resource = (Resource)obj;
            return this.getUri().equals(resource.getUri()) && this.getType().equals((Object)resource.getType());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 31 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
    }
}

