/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.JarWildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.util.StringUtils;

public class ClasspathUriLocator
extends WildcardUriLocatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathUriLocator.class);
    public static final String PREFIX = "classpath:";

    public boolean accept(String url) {
        return ClasspathUriLocator.isValid(url);
    }

    public static boolean isValid(String uri) {
        return uri.trim().startsWith(PREFIX);
    }

    public InputStream locate(String uri) throws IOException {
        Validate.notNull((Object)uri, (String)"URI cannot be NULL!", (Object[])new Object[0]);
        String location = StringUtils.cleanPath(uri.replaceFirst(PREFIX, "")).trim();
        if (this.getWildcardStreamLocator().hasWildcard(location)) {
            return this.locateWildcardStream(uri, location);
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (is == null) {
            throw new IOException("Couldn't get InputStream from this resource: " + uri);
        }
        return is;
    }

    private InputStream locateWildcardStream(String uri, String location) throws IOException {
        LOG.debug("wildcard detected for location: {}", (Object)location);
        String fullPath = "/" + FilenameUtils.getFullPathNoEndSeparator((String)location);
        URL url = this.getClass().getResource(fullPath);
        if (url == null) {
            url = this.getClass().getResource("");
        }
        if (url == null) {
            String message = "Couldn't get URL for the following path: " + fullPath;
            LOG.warn(message);
            throw new IOException(message);
        }
        return this.getWildcardStreamLocator().locateStream(uri, new File(url.getFile()));
    }

    public WildcardStreamLocator newWildcardStreamLocator() {
        return new JarWildcardStreamLocator(){

            public boolean hasWildcard(String uri) {
                return !ClasspathUriLocator.this.disableWildcards() && super.hasWildcard(uri);
            }
        };
    }
}

