/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.http.DelegatingServletOutputStream;
import ro.isdc.wro.util.WroUtil;

public final class DispatcherStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherStreamLocator.class);

    public InputStream getInputStream(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        Validate.notNull((Object)request);
        Validate.notNull((Object)response);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean warnOnEmptyStream = false;
        Context originalContext = Context.get();
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(location);
            if (dispatcher == null) {
                String servletContextPath = request.getRequestURL().toString().replace(request.getServletPath(), "");
                String absolutePath = servletContextPath + location;
                URL url = new URL(absolutePath);
                URLConnection conn = url.openConnection();
                int timeout = (int)TimeUnit.MILLISECONDS.convert(Context.get().getConfig().getConnectionTimeout(), TimeUnit.SECONDS);
                LOG.debug("Computed timeout milliseconds: {}", (Object)timeout);
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                InputStream inputStream = conn.getInputStream();
                return inputStream;
            }
            ServletRequest wrappedRequest = this.getWrappedServletRequest(request, location);
            ServletResponse wrappedResponse = this.getWrappedServletResponse(response, os);
            LOG.debug("dispatching request to location: " + location);
            dispatcher.include(wrappedRequest, wrappedResponse);
            warnOnEmptyStream = true;
            wrappedResponse.getWriter().flush();
            os.close();
        }
        catch (Exception e) {
            LOG.debug("[FAIL] Error while dispatching the request for location {}", (Object)location);
            throw new IOException("Error while dispatching the request for location " + location);
        }
        finally {
            if (warnOnEmptyStream && os.size() == 0) {
                LOG.warn("Wrong or empty resource with location: {}", (Object)location);
            }
            if (!Context.isContextSet()) {
                Context.set(originalContext);
            }
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private ServletRequest getWrappedServletRequest(HttpServletRequest request, final String location) {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                return this.getContextPath() + location;
            }

            public String getPathInfo() {
                return WroUtil.getPathInfoFromLocation(location);
            }

            public String getServletPath() {
                return WroUtil.getServletPathFromLocation(location);
            }
        };
        return wrappedRequest;
    }

    private ServletResponse getWrappedServletResponse(HttpServletResponse response, final ByteArrayOutputStream os) {
        HttpServletResponseWrapper wrappedResponse = new HttpServletResponseWrapper(response){
            private PrintWriter pw;
            private ServletOutputStream sos;
            {
                super(x0);
                this.pw = new PrintWriter(os);
                this.sos = new DelegatingServletOutputStream(os);
            }

            public void sendError(int sc) throws IOException {
                this.onError(sc, "");
                super.sendError(sc);
            }

            public void sendError(int sc, String msg) throws IOException {
                this.onError(sc, msg);
                super.sendError(sc, msg);
            }

            private void onError(int sc, String msg) {
                LOG.debug("Error detected with code: {} and message: {}", (Object)sc, (Object)msg);
                ByteArrayOutputStream emptyStream = new ByteArrayOutputStream();
                this.pw = new PrintWriter(emptyStream);
                this.sos = new DelegatingServletOutputStream(emptyStream);
            }

            public ServletOutputStream getOutputStream() throws IOException {
                return this.sos;
            }

            public void sendRedirect(String location) throws IOException {
                try {
                    LOG.debug("redirecting to: {}", (Object)location);
                    URL url = new URL(location);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setUseCaches(false);
                    InputStream is = connection.getInputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)this.sos);
                    is.close();
                }
                catch (IOException e) {
                    LOG.warn("Invalid response for location: " + location);
                    throw e;
                }
            }

            public PrintWriter getWriter() throws IOException {
                return this.pw;
            }
        };
        return wrappedResponse;
    }
}

