/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.resource.locator.DispatcherStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.WroUtil;

public class ServletContextUriLocator
extends WildcardUriLocatorSupport {
    static final Logger LOG = LoggerFactory.getLogger(ServletContextUriLocator.class);
    public static final String PREFIX = "/";
    private static final String PROTECTED_PREFIX = "/WEB-INF/";
    private final DispatcherStreamLocator dispatcherStreamLocator = new DispatcherStreamLocator();

    public boolean accept(String uri) {
        return ServletContextUriLocator.isValid(uri);
    }

    public static boolean isValid(String uri) {
        return uri.trim().startsWith(PREFIX);
    }

    public static boolean isProtectedResource(String uri) {
        return WroUtil.startsWithIgnoreCase(uri, PROTECTED_PREFIX);
    }

    public InputStream locate(String uri) throws IOException {
        InputStream inputStream;
        block7: {
            Validate.notNull((Object)uri, (String)"URI cannot be NULL!", (Object[])new Object[0]);
            LOG.debug("locate resource: {}", (Object)uri);
            ServletContext servletContext = Context.get().getServletContext();
            try {
                if (this.getWildcardStreamLocator().hasWildcard(uri)) {
                    String fullPath = FilenameUtils.getFullPath((String)uri);
                    String realPath = servletContext.getRealPath(fullPath);
                    if (realPath == null) {
                        String message = "Could not determine realPath for resource: " + uri;
                        LOG.error(message);
                        throw new IOException(message);
                    }
                    return this.getWildcardStreamLocator().locateStream(uri, new File(realPath));
                }
            }
            catch (IOException e) {
                if (e instanceof WildcardExpanderModelTransformer.NoMoreAttemptsIOException) {
                    throw e;
                }
                LOG.warn("Couldn't localize the stream containing wildcard. Original error message: '{}'", (Object)(e.getMessage() + "\".\n Trying to locate the stream without the wildcard."));
            }
            HttpServletRequest request = Context.get().getRequest();
            HttpServletResponse response = Context.get().getResponse();
            inputStream = null;
            try {
                inputStream = this.dispatcherStreamLocator.getInputStream(request, response, uri);
            }
            catch (IOException e) {
                LOG.debug("retrieving servletContext stream for uri: {}", (Object)uri);
                inputStream = servletContext.getResourceAsStream(uri);
                if (inputStream != null) break block7;
                LOG.error("Exception while reading resource from " + uri);
                throw new IOException("Exception while reading resource from " + uri);
            }
        }
        return inputStream;
    }
}

