/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.wildcard;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.IOFileFilterDecorator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardExpandedHandlerAware;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWildcardStreamLocator
implements WildcardStreamLocator,
WildcardExpandedHandlerAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWildcardStreamLocator.class);
    public static final String RECURSIVE_WILDCARD = "**";
    private static final String WILDCARD_REGEX = "^(?:(?!http))(.)*[\\*\\?]+(.)*";
    private Transformer<Collection<File>> wildcardExpanderHandler;

    @Override
    public boolean hasWildcard(String uri) {
        return uri.matches(WILDCARD_REGEX);
    }

    @Override
    public InputStream locateStream(String uri, File folder) throws IOException {
        Collection<File> files = this.findMatchedFiles(uri, folder);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (File file : files) {
            FileInputStream is = new FileInputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)out);
            ((InputStream)is).close();
        }
        return new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
    }

    private Collection<File> findMatchedFiles(String uri, File folder) throws IOException {
        if (uri == null || folder == null || !folder.isDirectory()) {
            StringBuffer message = new StringBuffer("Invalid folder provided");
            if (folder != null) {
                message.append(", with path: " + folder.getPath());
            }
            message.append(", with fileNameWithWildcard: " + uri);
            throw new IOException(message.toString());
        }
        if (!this.hasWildcard(uri)) {
            throw new IOException("No wildcard detected for the uri: " + uri);
        }
        String wildcard = FilenameUtils.getName((String)uri);
        LOG.debug("uri: {}", (Object)uri);
        LOG.debug("folder: {}", (Object)folder.getPath());
        LOG.debug("wildcard: {}", (Object)wildcard);
        final TreeMap uriToFileMap = new TreeMap();
        final TreeSet<File> allFiles = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        final String uriFolder = FilenameUtils.getFullPathNoEndSeparator((String)uri);
        final String parentFolderPath = folder.getPath();
        IOFileFilterDecorator fileFilter = new IOFileFilterDecorator((IOFileFilter)new WildcardFileFilter(wildcard)){

            public boolean accept(File file) {
                boolean accept = super.accept(file);
                if (accept) {
                    allFiles.add(file);
                    if (!file.isDirectory()) {
                        String relativeFilePath = file.getPath().replace(parentFolderPath, "");
                        String resourceUri = uriFolder + relativeFilePath.replace('\\', '/');
                        uriToFileMap.put(resourceUri, file);
                        LOG.debug("\tfoundUri: {}", (Object)resourceUri);
                    }
                }
                return accept;
            }
        };
        FileUtils.listFiles((File)folder, (IOFileFilter)fileFilter, (IOFileFilter)this.getFolderFilter(wildcard));
        LOG.debug("map files: {}", uriToFileMap.keySet());
        Collection<File> files = uriToFileMap.values();
        if (files.isEmpty()) {
            LOG.warn("No files found inside the {} for wildcard: {}", (Object)folder.getPath(), (Object)wildcard);
        }
        this.handleFoundResources(files);
        this.handleFoundAllFiles(allFiles);
        return files;
    }

    private void handleFoundAllFiles(Set<File> allFiles) throws IOException {
        if (this.wildcardExpanderHandler != null) {
            try {
                this.wildcardExpanderHandler.transform(allFiles);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Exception during expanding wildcard: " + e.getMessage());
            }
        }
    }

    protected void handleFoundResources(Collection<File> files) throws IOException {
    }

    private IOFileFilter getFolderFilter(String wildcard) {
        boolean recursive = wildcard.contains(RECURSIVE_WILDCARD);
        return recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE;
    }

    @Override
    public void setWildcardExpanderHandler(Transformer<Collection<File>> handler) {
        this.wildcardExpanderHandler = handler;
    }
}

