/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.wildcard;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.DefaultWildcardStreamLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarWildcardStreamLocator
extends DefaultWildcardStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JarWildcardStreamLocator.class);

    @Override
    public InputStream locateStream(String uri, File folder) throws IOException {
        File jarPath = new File(StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)folder.getPath(), (String)"!"), (String)"file:"));
        LOG.debug("jarPath: {}", (Object)jarPath);
        for (String supportedExtension : this.getSupportedContainerExtensions()) {
            LOG.debug("\tsupportedExtension: {}", (Object)supportedExtension);
            if (!jarPath.getPath().endsWith(supportedExtension)) continue;
            LOG.debug("\t\tLocating stream from jar");
            return this.locateStreamFromJar(uri, jarPath);
        }
        return super.locateStream(uri, folder);
    }

    protected List<String> getSupportedContainerExtensions() {
        return Arrays.asList(".jar");
    }

    protected boolean accept(JarEntry entry, String wildcard) {
        return FilenameUtils.wildcardMatch((String)entry.getName(), (String)wildcard);
    }

    protected JarFile open(File jarFile) {
        try {
            Validate.isTrue((boolean)jarFile.exists(), (String)"The JAR file must exists.", (Object[])new Object[0]);
            return new JarFile(jarFile);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot read the JAR file: " + jarFile, ex);
        }
    }

    protected final InputStream locateStreamFromJar(String uri, File jarPath) throws IOException {
        String classPath = FilenameUtils.getPath((String)uri);
        String wildcard = FilenameUtils.getName((String)uri);
        if (classPath.startsWith("classpath:")) {
            classPath = StringUtils.substringAfter((String)classPath, (String)"classpath:");
        }
        JarFile file = this.open(jarPath);
        Enumeration<JarEntry> entries = file.entries();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(classPath) || !this.accept(entry, wildcard)) continue;
            InputStream is = file.getInputStream(entry);
            IOUtils.copy((InputStream)is, (OutputStream)out);
            is.close();
        }
        return new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
    }
}

