/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.MinimizeAware;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.SupportedResourceTypeAware;
import ro.isdc.wro.model.resource.processor.impl.MultiLineCommentStripperProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.ConformColorsCssProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssCompressorProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssDataUriPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssVariablesProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.DuplicatesAwareCssDataUriPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.JawrCssMinifierProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.VariablizeColorsCssProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.JSMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.SemicolonAppenderPreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorsUtils {
    public static <T> Collection<T> getMinimizeFreeProcessors(Collection<T> processors) {
        ArrayList<T> result = new ArrayList<T>();
        for (T processor : processors) {
            if (processor.getClass().isAnnotationPresent(Minimize.class)) continue;
            result.add(processor);
        }
        return result;
    }

    public static <T> boolean isMinimizeAwareProcessor(T processor) {
        if (processor instanceof MinimizeAware) {
            return ((MinimizeAware)processor).isMinimize();
        }
        return processor.getClass().isAnnotationPresent(Minimize.class);
    }

    public static <T> SupportedResourceType getSupportedResourceType(T processor) {
        SupportedResourceType supportedType = processor.getClass().getAnnotation(SupportedResourceType.class);
        if (processor instanceof SupportedResourceTypeAware) {
            supportedType = ((SupportedResourceTypeAware)processor).getSupportedResourceType();
        }
        return supportedType;
    }

    public static <T> Collection<T> getProcessorsByType(ResourceType type, Collection<T> availableProcessors) {
        Validate.notNull(availableProcessors);
        ArrayList<T> found = new ArrayList<T>();
        for (T processor : availableProcessors) {
            SupportedResourceType supportedType = ProcessorsUtils.getSupportedResourceType(processor);
            boolean isTypeSatisfied = supportedType == null || supportedType != null && type == supportedType.value();
            if (!isTypeSatisfied) continue;
            found.add(processor);
        }
        return found;
    }

    public static ResourcePostProcessor toPostProcessor(final ResourcePreProcessor preProcessor) {
        return new ResourcePostProcessor(){

            public void process(Reader reader, Writer writer) throws IOException {
                preProcessor.process(null, reader, writer);
            }
        };
    }

    public static ResourcePreProcessor toPreProcessor(final ResourcePostProcessor postProcessor) {
        return new ResourcePreProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                postProcessor.process(reader, writer);
            }
        };
    }

    public static final <T extends ResourcePreProcessor> T findPreProcessorByClass(Class<T> processorClass, Collection<ResourcePreProcessor> preProcessors) {
        ResourcePreProcessor found = null;
        for (ResourcePreProcessor processor : preProcessors) {
            if (!processorClass.isInstance(processor)) continue;
            found = processor;
            return (T)found;
        }
        return null;
    }

    public static Map<String, ResourcePreProcessor> createPreProcessorsMap() {
        HashMap<String, ResourcePreProcessor> map = new HashMap<String, ResourcePreProcessor>();
        ProcessorsUtils.populateProcessorsMap(map);
        return map;
    }

    public static Map<String, ResourcePostProcessor> createPostProcessorsMap() {
        HashMap<String, ResourcePostProcessor> map = new HashMap<String, ResourcePostProcessor>();
        ProcessorsUtils.populateProcessorsMap(map);
        return map;
    }

    private static <T> void populateProcessorsMap(Map<String, T> map) {
        map.put("cssUrlRewriting", new CssUrlRewritingProcessor());
        map.put("cssImport", new CssImportPreProcessor());
        map.put("cssVariables", new CssVariablesProcessor());
        map.put("cssCompressor", new CssCompressorProcessor());
        map.put("semicolonAppender", new SemicolonAppenderPreProcessor());
        map.put("cssDataUri", new CssDataUriPreProcessor());
        map.put("duplicateAwareCssDataUri", new DuplicatesAwareCssDataUriPreProcessor());
        map.put("cssMinJawr", new JawrCssMinifierProcessor());
        map.put("cssMin", new CssMinProcessor());
        map.put("jsMin", new JSMinProcessor());
        map.put("variablizeColors", new VariablizeColorsCssProcessor());
        map.put("conformColors", new ConformColorsCssProcessor());
        map.put("multilineStripper", new MultiLineCommentStripperProcessor());
    }
}

