/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.impl.ExtensionsAwareProcessorDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableProcessorsFactory
implements ProcessorsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableProcessorsFactory.class);
    private static final String TOKEN_DELIMITER = ",";
    public static final String PARAM_PRE_PROCESSORS = "preProcessors";
    public static final String PARAM_POST_PROCESSORS = "postProcessors";
    private Properties properties;
    private Map<String, ResourcePreProcessor> preProcessorsMap;
    private Map<String, ResourcePostProcessor> postProcessorsMap;

    protected Properties newProperties() {
        return new Properties();
    }

    private static List<String> getTokens(String input) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)input)) {
            String[] tokens;
            for (String token : tokens = input.split(TOKEN_DELIMITER)) {
                list.add(token.trim());
            }
        }
        return list;
    }

    public static String createItemsAsString(String ... items) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(TOKEN_DELIMITER);
        }
        return sb.toString();
    }

    @Override
    public final Collection<ResourcePreProcessor> getPreProcessors() {
        String processorsAsString = this.getProperties().getProperty(PARAM_PRE_PROCESSORS);
        return ConfigurableProcessorsFactory.getListOfItems(processorsAsString, this.getPreProcessorsMap());
    }

    @Override
    public final Collection<ResourcePostProcessor> getPostProcessors() {
        String processorsAsString = this.getProperties().getProperty(PARAM_POST_PROCESSORS);
        return ConfigurableProcessorsFactory.getListOfItems(processorsAsString, this.getPostProcessorsMap());
    }

    public static <T> List<T> getListOfItems(String itemsAsString, Map<String, T> map) {
        LOG.debug("itemsAsString: " + itemsAsString);
        ArrayList<T> list = new ArrayList<T>();
        List<String> tokenNames = ConfigurableProcessorsFactory.getTokens(itemsAsString);
        for (String tokenName : tokenNames) {
            LOG.debug("\ttokenName: {}", (Object)tokenName);
            Validate.notEmpty((CharSequence)tokenName);
            T processor = map.get(tokenName.trim());
            if (processor == null) {
                LOG.debug("[FAIL] no processor found named: {}. Proceeding with extension check. ", (Object)tokenName);
                Object[] tokens = tokenName.split("\\.");
                LOG.debug("split tokens: {}", (Object)Arrays.toString(tokens));
                if (tokens.length == 2) {
                    String processorName = ((String)tokens[0]).trim();
                    LOG.debug("processorName: {}", (Object)processorName);
                    processor = map.get(processorName);
                    if (processor != null && processor instanceof ResourcePreProcessor) {
                        String extension = ((String)tokens[1]).trim();
                        LOG.debug("adding Extension: {}", (Object)extension);
                        ExtensionsAwareProcessorDecorator.decorate((ResourcePreProcessor)processor).addExtension(extension);
                    }
                }
                if (processor == null) {
                    throw new WroRuntimeException("Unknown processor name: " + tokenName + ". Available processors are: " + map.keySet()).logError();
                }
            }
            list.add(processor);
        }
        return list;
    }

    public ConfigurableProcessorsFactory setPreProcessorsMap(Map<String, ResourcePreProcessor> map) {
        Validate.notNull(map);
        this.preProcessorsMap = map;
        return this;
    }

    public ConfigurableProcessorsFactory setPostProcessorsMap(Map<String, ResourcePostProcessor> map) {
        Validate.notNull(map);
        this.postProcessorsMap = map;
        return this;
    }

    public ConfigurableProcessorsFactory setProperties(Properties properties) {
        Validate.notNull((Object)properties);
        this.properties = properties;
        return this;
    }

    public Map<String, ResourcePreProcessor> newPreProcessorsMap() {
        return new HashMap<String, ResourcePreProcessor>();
    }

    public Map<String, ResourcePostProcessor> newPostProcessorsMap() {
        return new HashMap<String, ResourcePostProcessor>();
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.newProperties();
        }
        return this.properties;
    }

    private Map<String, ResourcePreProcessor> getPreProcessorsMap() {
        if (this.preProcessorsMap == null) {
            this.preProcessorsMap = this.newPreProcessorsMap();
        }
        return this.preProcessorsMap;
    }

    private Map<String, ResourcePostProcessor> getPostProcessorsMap() {
        if (this.postProcessorsMap == null) {
            this.postProcessorsMap = this.newPostProcessorsMap();
        }
        return this.postProcessorsMap;
    }
}

