/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.impl.AbstractProcessorDecorator;

public class CopyrightKeeperProcessorDecorator
extends AbstractProcessorDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(CopyrightKeeperProcessorDecorator.class);
    private static final Pattern PATTERN_COPYRIGHT = Pattern.compile("(?ims)/\\*!.*?\\*/");

    private CopyrightKeeperProcessorDecorator(ResourcePreProcessor preProcessor) {
        super(preProcessor);
    }

    private CopyrightKeeperProcessorDecorator(ResourcePostProcessor postProcessor) {
        super(postProcessor);
    }

    public static CopyrightKeeperProcessorDecorator decorate(ResourcePreProcessor preProcessor) {
        return new CopyrightKeeperProcessorDecorator(preProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            String content = IOUtils.toString((Reader)reader);
            Matcher originalMatcher = PATTERN_COPYRIGHT.matcher(content);
            StringBuffer copyrightBuffer = new StringBuffer();
            while (originalMatcher.find()) {
                LOG.debug("found copyright comment");
                copyrightBuffer.append(originalMatcher.group());
            }
            LOG.debug("buffer: {}", (Object)copyrightBuffer);
            StringWriter processedWriter = new StringWriter();
            this.getDecoratedProcessor().process(resource, new StringReader(content), processedWriter);
            Matcher processedMatcher = PATTERN_COPYRIGHT.matcher(((Object)processedWriter).toString());
            if (!processedMatcher.find()) {
                writer.write(copyrightBuffer.toString());
            }
            writer.write(((Object)processedWriter).toString());
        }
        finally {
            reader.close();
            writer.close();
        }
    }
}

