/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.DataUriGenerator;

@SupportedResourceType(value=ResourceType.CSS)
public abstract class AbstractCssUrlRewritingProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCssUrlRewritingProcessor.class);
    private static final String PATTERN_PATH = "url\\s*\\((\\s*['\"]?((?:.*?|\\s*?))['\"]?\\s*)\\)|src\\s*=\\s*['\"]((?:.|\\s)*?)['\"]";
    protected static final Pattern PATTERN = Pattern.compile("url\\s*\\((\\s*['\"]?((?:.*?|\\s*?))['\"]?\\s*)\\)|src\\s*=\\s*['\"]((?:.|\\s)*?)['\"]", 2);

    public void process(Reader reader, Writer writer) throws IOException {
        throw new WroRuntimeException("This processor: " + this.getClass().getSimpleName() + " cannot work as a postProcessor!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            String cssUri = resource.getUri();
            LOG.debug("cssUri: {}", (Object)cssUri);
            String css = IOUtils.toString((Reader)reader);
            String result = this.parseCss(css, cssUri);
            writer.write(result);
            this.onProcessCompleted();
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected void onProcessCompleted() {
    }

    private String parseCss(String cssContent, String cssUri) {
        Matcher matcher = PATTERN.matcher(cssContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String oldMatch = matcher.group();
            String urlGroup = matcher.group(3) != null ? matcher.group(3) : matcher.group(2);
            LOG.debug("urlGroup: {}", (Object)urlGroup);
            String urlContent = matcher.group(1) != null ? matcher.group(1) : urlGroup;
            Validate.notNull((Object)urlGroup);
            if (!this.isReplaceNeeded(urlGroup)) continue;
            String replacedUrl = this.replaceImageUrl(cssUri, urlGroup);
            LOG.debug("replaced old Url: [{}] with: [{}].", (Object)urlContent, (Object)StringUtils.abbreviate((String)replacedUrl, (int)40));
            String newReplacement = oldMatch.replace(urlContent, replacedUrl);
            this.onUrlReplaced(replacedUrl);
            matcher.appendReplacement(sb, newReplacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected void onUrlReplaced(String replacedUrl) {
    }

    protected abstract String replaceImageUrl(String var1, String var2);

    protected final String cleanImageUrl(String imageUrl) {
        return imageUrl.replace('\'', ' ').replace('\"', ' ').trim();
    }

    protected boolean isReplaceNeeded(String url) {
        return !UrlUriLocator.isValid(url) && !DataUriGenerator.isDataUri(url.trim());
    }
}

