/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.support.DataUriGenerator;

public class CssDataUriPreProcessor
extends AbstractCssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssDataUriPreProcessor.class);
    public static final String ALIAS = "cssDataUri";
    private static final int SIZE_LIMIT = 32768;
    private DataUriGenerator dataUriGenerator;
    @Inject
    private UriLocatorFactory uriLocatorFactory;

    protected String replaceImageUrl(String cssUri, String imageUrl) {
        Validate.notNull((Object)this.uriLocatorFactory);
        LOG.debug("replace url for image: {} from css: {}", (Object)imageUrl, (Object)cssUri);
        String cleanImageUrl = this.cleanImageUrl(imageUrl);
        String fileName = FilenameUtils.getName((String)imageUrl);
        String fullPath = cleanImageUrl;
        if (!cleanImageUrl.startsWith("http")) {
            fullPath = FilenameUtils.getFullPath((String)cssUri) + cleanImageUrl;
        }
        String result = imageUrl;
        try {
            String dataUri = this.getDataUriGenerator().generateDataURI(this.uriLocatorFactory.locate(fullPath), fileName);
            if (this.replaceWithDataUri(dataUri)) {
                result = dataUri;
                LOG.debug("dataUri replacement: {}", (Object)StringUtils.abbreviate((String)dataUri, (int)30));
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't extract dataUri from:" + fullPath + ", because: " + e.getMessage());
        }
        return result;
    }

    private DataUriGenerator getDataUriGenerator() {
        if (this.dataUriGenerator == null) {
            this.dataUriGenerator = new DataUriGenerator();
        }
        return this.dataUriGenerator;
    }

    protected boolean replaceWithDataUri(String dataUri) throws UnsupportedEncodingException {
        byte[] bytes = dataUri.getBytes("UTF8");
        boolean exceedLimit = bytes.length >= 32768;
        LOG.debug("dataUri size: {}KB, limit exceeded: {}", (Object)(bytes.length / 1024), (Object)exceedLimit);
        return !exceedLimit;
    }

    protected boolean isReplaceNeeded(String url) {
        return !DataUriGenerator.isDataUri(url.trim());
    }
}

