/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssUrlRewritingProcessor;

public class CssUrlRewritingProcessor
extends AbstractCssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssUrlRewritingProcessor.class);
    public static final String ALIAS = "cssUrlRewriting";
    public static final String PATH_RESOURCES = "wroResources";
    public static final String PARAM_RESOURCE_ID = "id";
    private final Set<String> allowedUrls = Collections.synchronizedSet(new HashSet());
    private String aggregatedPathPrefix;

    private CssUrlRewritingProcessor setAggregatedFolderPath(String aggregatedFolderPath) {
        this.aggregatedPathPrefix = this.computeAggregationPathPrefix(aggregatedFolderPath);
        LOG.debug("computed aggregatedPathPrefix {}", (Object)this.aggregatedPathPrefix);
        return this;
    }

    protected void onProcessCompleted() {
        LOG.debug("allowed urls: {}", this.allowedUrls);
    }

    protected void onUrlReplaced(String replacedUrl) {
        String allowedUrl = StringUtils.removeStart((String)replacedUrl, (String)this.getUrlPrefix());
        LOG.debug("adding allowed url: {}", (Object)allowedUrl);
        this.allowedUrls.add(allowedUrl);
    }

    protected String replaceImageUrl(String cssUri, String imageUrl) {
        if (ServletContextUriLocator.isValid(cssUri)) {
            if (ServletContextUriLocator.isValid(imageUrl)) {
                return imageUrl;
            }
            if (ServletContextUriLocator.isProtectedResource(cssUri)) {
                return this.getUrlPrefix() + this.computeNewImageLocation(cssUri, imageUrl);
            }
            this.setAggregatedFolderPath(Context.get().getAggregatedFolderPath());
            LOG.debug("aggregatedPathPrefix: {}", (Object)this.aggregatedPathPrefix);
            return this.computeNewImageLocation(this.aggregatedPathPrefix + cssUri, imageUrl);
        }
        if (UrlUriLocator.isValid(cssUri)) {
            return this.computeNewImageLocation(cssUri, imageUrl);
        }
        if (ClasspathUriLocator.isValid(cssUri)) {
            return this.getUrlPrefix() + this.computeNewImageLocation(cssUri, imageUrl);
        }
        throw new WroRuntimeException("Could not replace imageUrl: " + imageUrl + ", contained at location: " + cssUri);
    }

    private String computeAggregationPathPrefix(String aggregatedFolderPath) {
        LOG.debug("aggregatedFolderPath: {}", (Object)aggregatedFolderPath);
        String computedPrefix = "";
        if (aggregatedFolderPath != null) {
            String folderPrefix = "/..";
            StringBuffer result = new StringBuffer("");
            Object[] depthFolders = aggregatedFolderPath.split("/");
            LOG.debug("subfolders {}", (Object)Arrays.toString(depthFolders));
            for (Object folder : depthFolders) {
                if (StringUtils.isEmpty((CharSequence)folder)) continue;
                result.append("/..");
            }
            computedPrefix = result.toString().replaceFirst("/", "");
        }
        LOG.debug("computedPrefix: {}", (Object)computedPrefix);
        return computedPrefix;
    }

    private String computeNewImageLocation(String cssUri, String imageUrl) {
        LOG.debug("cssUri: {}, imageUrl {}", (Object)cssUri, (Object)imageUrl);
        String cleanImageUrl = this.cleanImageUrl(imageUrl);
        int idxLastSeparator = cssUri.lastIndexOf("/");
        if (idxLastSeparator == -1) {
            if (ClasspathUriLocator.isValid(cssUri) && (idxLastSeparator = cssUri.lastIndexOf("classpath:")) >= 0) {
                idxLastSeparator += "classpath:".length() - 1;
            }
            if (idxLastSeparator < 0) {
                throw new IllegalStateException("Invalid cssUri: " + cssUri + ". Should contain at least one '/' character!");
            }
        }
        String cssUriFolder = cssUri.substring(0, idxLastSeparator + 1);
        String processedImageUrl = cleanImageUrl.startsWith("/") ? cleanImageUrl.substring(1) : cleanImageUrl;
        String computedImageLocation = ro.isdc.wro.util.StringUtils.cleanPath(cssUriFolder + processedImageUrl);
        LOG.debug("computedImageLocation: {}", (Object)computedImageLocation);
        return computedImageLocation;
    }

    public final boolean isUriAllowed(String uri) {
        return this.allowedUrls.contains(uri);
    }

    protected String getUrlPrefix() {
        String requestURI = Context.get().getRequest().getRequestURI();
        return String.format("%s?%s=", FilenameUtils.getFullPath((String)requestURI) + PATH_RESOURCES, PARAM_RESOURCE_ID);
    }
}

