/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.JSMin;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class JSMinProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSMinProcessor.class);
    public static final String ALIAS = "jsMin";

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            String encoding = Context.get().getConfig().getEncoding();
            ProxyInputStream is = new ProxyInputStream((InputStream)new ReaderInputStream(reader, encoding)){};
            ProxyOutputStream os = new ProxyOutputStream((OutputStream)new WriterOutputStream(writer, encoding));
            JSMin jsmin = new JSMin((InputStream)is, (OutputStream)os);
            jsmin.jsmin();
            is.close();
            os.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

