/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardExpandedHandlerAware;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardExpanderModelTransformer
implements Transformer<WroModel> {
    private static final Logger LOG = LoggerFactory.getLogger(WildcardExpanderModelTransformer.class);
    @Inject
    private UriLocatorFactory uriLocatorFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WroModel transform(WroModel input) {
        WroModel model = input;
        for (Group group : model.getGroups()) {
            List<Resource> resources = group.getResources();
            for (Resource resource : resources) {
                WildcardStreamLocator wildcardStreamLocator;
                UriLocator uriLocator = this.uriLocatorFactory.getInstance(resource.getUri());
                if (!(uriLocator instanceof WildcardUriLocatorSupport) || !(wildcardStreamLocator = ((WildcardUriLocatorSupport)uriLocator).getWildcardStreamLocator()).hasWildcard(resource.getUri()) || !(wildcardStreamLocator instanceof WildcardExpandedHandlerAware)) continue;
                WildcardExpandedHandlerAware expandedHandler = (WildcardExpandedHandlerAware)((Object)wildcardStreamLocator);
                LOG.debug("Expanding resource: {}", (Object)resource.getUri());
                String baseNameFolder = this.computeBaseNameFolder(resource, uriLocator, expandedHandler);
                LOG.debug("baseNameFolder: {}", (Object)baseNameFolder);
                expandedHandler.setWildcardExpanderHandler(this.createExpanderHandler(group, resource, baseNameFolder));
                try {
                    uriLocator.locate(resource.getUri());
                }
                catch (IOException e) {
                    LOG.warn("[FAIL] problem while trying to expand wildcard for the following resource uri: {}", (Object)resource.getUri());
                }
                finally {
                    expandedHandler.setWildcardExpanderHandler(null);
                }
            }
        }
        LOG.debug("Transformed model: {}", (Object)model);
        return model;
    }

    private String computeBaseNameFolder(Resource resource, UriLocator uriLocator, WildcardExpandedHandlerAware expandedHandler) {
        LOG.debug("computeBaseNameFolder for resource {}", (Object)resource);
        String resourcePath = FilenameUtils.getFullPath((String)resource.getUri()) + "**";
        LOG.debug("resourcePath: {}", (Object)resourcePath);
        final ThreadLocal baseNameFolderHolder = new ThreadLocal();
        expandedHandler.setWildcardExpanderHandler(new Transformer<Collection<File>>(){

            @Override
            public Collection<File> transform(Collection<File> input) throws Exception {
                LOG.debug("\texpanded Files: {}", input);
                Iterator<File> i$ = input.iterator();
                if (i$.hasNext()) {
                    File file = i$.next();
                    LOG.debug("\tsetting baseNameFolder: {}", (Object)file.getParent());
                    baseNameFolderHolder.set(file.getParent());
                }
                throw new NoMoreAttemptsIOException("BaseNameFolder computed successfully, skip further wildcard processing..");
            }
        });
        try {
            uriLocator.locate(resourcePath);
        }
        catch (Exception e) {
            LOG.debug("[FAIL] Exception caught during wildcard expanding for resource: {}\n with exception message {}", (Object)resourcePath, (Object)e.getMessage());
        }
        if (baseNameFolderHolder.get() == null) {
            LOG.debug("[FAIL] Cannot compute baseName folder for resource: {}", (Object)resource);
        }
        return (String)baseNameFolderHolder.get();
    }

    public Transformer<Collection<File>> createExpanderHandler(final Group group, final Resource resource, final String baseNameFolder) {
        LOG.debug("createExpanderHandler using baseNameFolder: {}\n for resource {}", (Object)baseNameFolder, (Object)resource);
        Transformer<Collection<File>> handler = new Transformer<Collection<File>>(){

            @Override
            public Collection<File> transform(Collection<File> files) {
                if (baseNameFolder == null) {
                    LOG.warn("The resource {} is probably invalid, removing it from the group.", (Object)resource);
                    group.replace(resource, new ArrayList<Resource>());
                } else {
                    ArrayList<Resource> expandedResources = new ArrayList<Resource>();
                    for (File file : files) {
                        String resourcePath = FilenameUtils.getFullPathNoEndSeparator((String)resource.getUri());
                        LOG.debug("resourcePath: {}", (Object)resourcePath);
                        String computedResourceUri = resourcePath + StringUtils.removeStart((String)file.getPath(), (String)baseNameFolder).replace('\\', '/');
                        Resource expandedResource = Resource.create(computedResourceUri, resource.getType());
                        LOG.debug("\texpanded resource: {}", (Object)expandedResource);
                        expandedResources.add(expandedResource);
                    }
                    LOG.debug("\treplace resource {}", (Object)resource);
                    group.replace(resource, expandedResources);
                }
                return null;
            }
        };
        return handler;
    }

    public static class NoMoreAttemptsIOException
    extends IOException {
        public NoMoreAttemptsIOException(String message) {
            super(message);
        }
    }
}

