/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.util.Transformer;
import ro.isdc.wro.util.Transformers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WroTestUtils.class);

    public static InputStream getPropertiesStream(Properties properties) {
        StringWriter propsAsString = new StringWriter();
        properties.list(new PrintWriter(propsAsString));
        return new ByteArrayInputStream(propsAsString.toString().getBytes());
    }

    public static void compareProcessedResourceContents(String inputResourceUri, String expectedContentResourceUri, ResourcePostProcessor processor) throws IOException {
        Reader resultReader = WroTestUtils.getReaderFromUri(inputResourceUri);
        Reader expectedReader = WroTestUtils.getReaderFromUri(expectedContentResourceUri);
        WroTestUtils.compare(resultReader, expectedReader, processor);
    }

    public static void compareProcessedResourceContents(String inputResourceUri, String expectedContentResourceUri, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareProcessedResourceContents(inputResourceUri, expectedContentResourceUri, ProcessorsUtils.toPostProcessor(processor));
    }

    private static Reader getReaderFromUri(String uri) throws IOException {
        return new BufferedReader(new InputStreamReader(WroTestUtils.createDefaultUriLocatorFactory().locate(uri)));
    }

    private static UriLocatorFactory createDefaultUriLocatorFactory() {
        return new DefaultUriLocatorFactory();
    }

    public static InputStream getInputStream(String uri) throws IOException {
        return WroTestUtils.createDefaultUriLocatorFactory().locate(uri);
    }

    public static void init(WroModelFactory factory) {
        new BaseWroManagerFactory().setModelFactory(factory).create();
    }

    public static void initProcessor(ResourcePreProcessor processor) {
        BaseWroManagerFactory factory = new BaseWroManagerFactory();
        factory.setProcessorsFactory(new SimpleProcessorsFactory().addPreProcessor(processor));
        WroManager manager = factory.create();
        Injector injector = new Injector(manager);
        injector.inject(processor);
    }

    public static void initProcessor(ResourcePostProcessor processor) {
        BaseWroManagerFactory factory = new BaseWroManagerFactory();
        factory.setProcessorsFactory(new SimpleProcessorsFactory().addPostProcessor(processor));
        WroManager manager = factory.create();
        Injector injector = new Injector(manager);
        injector.inject(processor);
    }

    public static void compare(Reader resultReader, Reader expectedReader, ResourcePostProcessor processor) throws IOException {
        StringWriter resultWriter = new StringWriter();
        processor.process(resultReader, resultWriter);
        StringWriter expectedWriter = new StringWriter();
        IOUtils.copy((Reader)expectedReader, (Writer)expectedWriter);
        WroTestUtils.compare(((Object)expectedWriter).toString(), ((Object)resultWriter).toString());
        expectedReader.close();
        ((Writer)expectedWriter).close();
    }

    public static void compare(InputStream input, InputStream expected, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compare(new InputStreamReader(input), new InputStreamReader(expected), processor);
    }

    public static void compare(InputStream expected, InputStream actual) throws IOException {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        String encoding = Context.get().getConfig().getEncoding();
        WroTestUtils.compare(IOUtils.toString((InputStream)expected, (String)encoding), IOUtils.toString((InputStream)actual, (String)encoding));
        expected.close();
        actual.close();
    }

    public static void compare(String expected, String actual) {
        try {
            String in = WroTestUtils.replaceTabsWithSpaces(expected.trim());
            String out = WroTestUtils.replaceTabsWithSpaces(actual.trim());
            Assert.assertEquals((String)in, (String)out);
            LOG.debug("Compare.... [OK]");
        }
        catch (ComparisonFailure e) {
            LOG.debug("Compare.... [FAIL]", (Object)e.getMessage());
            throw e;
        }
    }

    private static String replaceTabsWithSpaces(String input) {
        return input.replaceAll("\\t", "  ").replaceAll("\\r", "");
    }

    public static void compareSameFolderByExtension(File sourceFolder, String sourceFileExtension, String targetFileExtension, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromSameFolder(sourceFolder, (IOFileFilter)new WildcardFileFilter("*." + sourceFileExtension), Transformers.extensionTransformer(targetFileExtension), processor);
    }

    public static void compareSameFolderByExtension(File sourceFolder, String sourceFileExtension, String targetFileExtension, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareFromSameFolder(sourceFolder, (IOFileFilter)new WildcardFileFilter("*." + sourceFileExtension), Transformers.extensionTransformer(targetFileExtension), processor);
    }

    public static void compareSameFolderByExtension(File sourceFolder, String sourceFileExtension, Transformer<String> toTargetFileName, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromSameFolder(sourceFolder, (IOFileFilter)new WildcardFileFilter("*." + sourceFileExtension), toTargetFileName, processor);
    }

    public static void compareFromSameFolder(File sourceFolder, IOFileFilter sourceFileFilter, Transformer<String> toTargetFileName, final ResourcePostProcessor processor) throws IOException {
        ResourcePreProcessor preProcessor = new ResourcePreProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                processor.process(reader, writer);
            }
        };
        WroTestUtils.compareFromSameFolder(sourceFolder, sourceFileFilter, toTargetFileName, preProcessor);
    }

    public static void compareFromSameFolder(File sourceFolder, IOFileFilter sourceFileFilter, Transformer<String> toTargetFileName, final ResourcePreProcessor processor) throws IOException {
        Collection files = FileUtils.listFiles((File)sourceFolder, (IOFileFilter)sourceFileFilter, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (final File file : files) {
            LOG.debug("processing: {}", (Object)file.getName());
            File targetFile = null;
            try {
                targetFile = new File(sourceFolder, toTargetFileName.transform(file.getName()));
                FileInputStream targetFileStream = new FileInputStream(targetFile);
                LOG.debug("comparing with: {}", (Object)targetFile.getName());
                WroTestUtils.compare(new FileInputStream(file), targetFileStream, new ResourcePostProcessor(){

                    public void process(Reader reader, Writer writer) throws IOException {
                        processor.process(Resource.create("file:" + file.getPath(), ResourceType.CSS), reader, writer);
                    }
                });
                ++processedNumber;
            }
            catch (Exception e) {
                LOG.warn("Skip comparison because couldn't find the TARGET file " + targetFile.getPath());
            }
        }
        WroTestUtils.logSuccess(processedNumber);
    }

    private static void logSuccess(int size) {
        if (size == 0) {
            throw new IllegalStateException("No files compared. Check if there is at least one resource to compare");
        }
        LOG.debug("===============");
        LOG.debug("Successfully compared: {} files.", (Object)size);
        LOG.debug("===============");
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, fileFilter, Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, TrueFileFilter.TRUE, Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, TrueFileFilter.TRUE, Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFoldersByExtension(File sourceFolder, File targetFolder, String extension, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, (IOFileFilter)new WildcardFileFilter("*." + extension), Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFoldersByExtension(File sourceFolder, File targetFolder, String extension, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, (IOFileFilter)new WildcardFileFilter("*." + extension), Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, Transformer<String> toTargetFileName, final ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, fileFilter, toTargetFileName, new ResourcePreProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                processor.process(reader, writer);
            }
        });
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, Transformer<String> toTargetFileName, final ResourcePreProcessor preProcessor) throws IOException {
        LOG.debug("sourceFolder: {}", (Object)sourceFolder);
        LOG.debug("targetFolder: {}", (Object)targetFolder);
        Collection files = FileUtils.listFiles((File)sourceFolder, (IOFileFilter)fileFilter, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (final File file : files) {
            File targetFile = null;
            try {
                targetFile = new File(targetFolder, toTargetFileName.transform(file.getName()));
                FileInputStream targetFileStream = new FileInputStream(targetFile);
                LOG.debug("processing: {}", (Object)file.getName());
                WroTestUtils.compare(new FileInputStream(file), targetFileStream, new ResourcePostProcessor(){

                    public void process(Reader reader, Writer writer) throws IOException {
                        ResourceType resourceType = ResourceType.JS;
                        try {
                            resourceType = ResourceType.get(FilenameUtils.getExtension((String)file.getPath()));
                        }
                        catch (IllegalArgumentException e) {
                            LOG.warn("unkown resource type for file: {}, assuming resource type is: {}", (Object)file.getPath(), (Object)resourceType);
                        }
                        preProcessor.process(Resource.create("file:" + file.getPath(), resourceType), reader, writer);
                    }
                });
                ++processedNumber;
            }
            catch (IOException e) {
                LOG.warn("Skip comparison because couldn't find the TARGET file " + targetFile.getPath());
            }
            catch (Exception e) {
                throw new WroRuntimeException("A problem during transformation occured", e);
            }
        }
        WroTestUtils.logSuccess(processedNumber);
    }

    public static void runConcurrently(Callable<Void> task) throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(5);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < 10; ++i) {
            futures.add(service.submit(task));
        }
        for (Future future : futures) {
            future.get();
        }
    }
}

