/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.util.Arrays;

public enum DBType {
    POSTGRESQL{

        @Override
        public String getDriverClassName() {
            return "org.postgresql.Driver";
        }
    }
    ,
    MSSQL{

        @Override
        public String getDriverClassName() {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
    }
    ,
    ORACLE{

        @Override
        public String getDriverClassName() {
            return "oracle.jdbc.driver.OracleDriver";
        }
    }
    ,
    FIREBIRD{

        @Override
        public String getDriverClassName() {
            return "org.firebirdsql.jdbc.FBDriver";
        }
    }
    ,
    H2{

        @Override
        public String getDriverClassName() {
            return "org.h2.Driver";
        }
    }
    ,
    UNKNOWN{

        @Override
        public String getDriverClassName() {
            return "";
        }
    };


    public abstract String getDriverClassName();

    public static DBType resolveByJdbcUrl(String url) {
        if (url.startsWith("jdbc:sqlserver")) {
            return MSSQL;
        }
        if (url.startsWith("jdbc:postgresql")) {
            return POSTGRESQL;
        }
        if (url.startsWith("jdbc:oracle")) {
            return ORACLE;
        }
        if (url.startsWith("jdbc:firebirdsql")) {
            return FIREBIRD;
        }
        if (url.startsWith("jdbc:h2")) {
            return H2;
        }
        return UNKNOWN;
    }

    public static DBType getByNameIgnoreCase(String name) {
        return Arrays.stream(DBType.values()).filter(n -> n.name().equalsIgnoreCase(name)).findFirst().get();
    }
}

